/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.punishment;

import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentFactory;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PunishmentTypeRegistry {
    private static final Map<Integer, PunishmentType> types = new HashMap<Integer, PunishmentType>();
    private static final Map<PunishmentType, PunishmentFactory> punishmentFactories = new HashMap<PunishmentType, PunishmentFactory>();

    public static void registerType(PunishmentType type, PunishmentFactory factory) {
        types.put(type.getId(), type);
        punishmentFactories.put(type, factory);
    }

    public static PunishmentType getType(int id) {
        return types.get(id);
    }

    @NotNull
    public static Punishment createPunishment(@NotNull PunishmentType type, @NotNull Map<String, Object> data) {
        PunishmentFactory factory = punishmentFactories.get(type);
        if (factory == null) {
            throw new IllegalStateException("No factory registered for punishment type: " + type.getName());
        }
        return factory.createPunishment(type, data);
    }

    @NotNull
    public static Punishment createPunishment(int id, @NotNull Map<String, Object> data) {
        PunishmentType type = PunishmentTypeRegistry.getType(id);
        if (type == null) {
            throw new IllegalArgumentException("No punishment type found for ID: " + id);
        }
        return PunishmentTypeRegistry.createPunishment(type, data);
    }

    @NotNull
    public static Collection<PunishmentType> getPunishmentTypes() {
        return new ArrayList<PunishmentType>(types.values());
    }

    private PunishmentTypeRegistry() {
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }
}

