/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.punishment;

import de.jvstvshd.necrify.api.punishment.PunishmentType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public enum StandardPunishmentType implements PunishmentType
{
    TEMPORARY_BAN(false, "BAN", 1),
    PERMANENT_BAN(true, "PERMANENT_BAN", 2),
    TEMPORARY_MUTE(false, "MUTE", 3),
    PERMANENT_MUTE(true, "PERMANENT_MUTE", 4),
    KICK(false, "KICK", 5);

    private final boolean isPermanent;
    private final String typeString;
    private final int id;

    private StandardPunishmentType(boolean isPermanent, String typeString, int id) {
        this.isPermanent = isPermanent;
        this.typeString = typeString;
        this.id = id;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    @Override
    public String getName() {
        return this.typeString;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<PunishmentType> getRelatedTypes() {
        return switch (this.ordinal()) {
            case 0, 1 -> List.of(TEMPORARY_BAN, PERMANENT_BAN);
            case 2, 3 -> List.of(TEMPORARY_MUTE, PERMANENT_MUTE);
            default -> List.of(this);
        };
    }
}

