/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.punishment.log;

import de.jvstvshd.necrify.api.punishment.log.PunishmentLogAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PunishmentLogActionRegistry {
    private static final Map<String, PunishmentLogAction> actions = new HashMap<String, PunishmentLogAction>();

    public static void registerAction(@NotNull PunishmentLogAction action) {
        actions.put(action.name(), action);
    }

    public static Optional<PunishmentLogAction> getAction(@NotNull String name) {
        return Optional.ofNullable(actions.get(name));
    }

    @Nullable
    public static PunishmentLogAction unregisterAction(String name) {
        return actions.remove(name);
    }

    public static Map<String, PunishmentLogAction> getActions() {
        return new HashMap<String, PunishmentLogAction>(actions);
    }

    static {
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CREATED);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CHANGE_REASON);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CHANGE_DURATION);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CHANGE_PREDECESSOR);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CHANGE_SUCCESSOR);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.REMOVED);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.INFORMATION);
        PunishmentLogActionRegistry.registerAction(PunishmentLogAction.CHANGE_TIME);
    }
}

