/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.punishment.log;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogAction;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import java.time.LocalDateTime;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PunishmentLogEntry(@Nullable NecrifyUser actor, @Nullable String message, @NotNull PunishmentDuration duration, @NotNull Component reason, @Nullable Punishment predecessor, @NotNull Punishment punishment, @Nullable Punishment successor, @NotNull LocalDateTime beginsAt, @NotNull PunishmentLogAction action, @NotNull PunishmentLog log, @NotNull LocalDateTime instant, int index) implements Comparable<PunishmentLogEntry>
{
    @NotNull
    public Optional<PunishmentLogEntry> previous() {
        return Optional.ofNullable(this.log.getEntries().get(this.index - 1));
    }

    @NotNull
    public PunishmentLogEntry previousOrThis() {
        return this.previous().orElse(this);
    }

    @NotNull
    public Optional<PunishmentLogEntry> next() {
        return Optional.ofNullable(this.log.getEntries().get(this.index + 1));
    }

    @NotNull
    public PunishmentLogEntry nextOrThis() {
        return this.next().orElse(this);
    }

    @NotNull
    public NecrifyUser getAffectedUser() {
        return this.punishment.getUser();
    }

    @Override
    public int compareTo(@NotNull PunishmentLogEntry o) {
        return Integer.compare(this.index, o.index);
    }
}

