/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.user;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Ban;
import de.jvstvshd.necrify.api.punishment.Kick;
import de.jvstvshd.necrify.api.punishment.Mute;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.user.CommandSender;
import de.jvstvshd.necrify.api.user.UserDeletionReason;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NecrifyUser
extends CommandSender {
    @NotNull
    public UUID getUuid();

    @Nullable
    public String getUsername();

    @NotNull
    public CompletableFuture<Ban> ban(@Nullable Component var1, @NotNull PunishmentDuration var2);

    @NotNull
    public CompletableFuture<Ban> banPermanent(@Nullable Component var1);

    @NotNull
    public CompletableFuture<Mute> mute(@Nullable Component var1, @NotNull PunishmentDuration var2);

    @NotNull
    public CompletableFuture<Mute> mutePermanent(@Nullable Component var1);

    @NotNull
    public CompletableFuture<Kick> kick(@Nullable Component var1);

    @NotNull
    public CompletableFuture<Punishment> punish(@NotNull Punishment var1);

    @NotNull
    public <T extends Punishment> List<T> getPunishments(PunishmentType ... var1);

    @NotNull
    public CompletableFuture<String> queryUsername(boolean var1);

    public boolean isWhitelisted();

    public CompletableFuture<Boolean> setWhitelisted(boolean var1);

    public CompletableFuture<Integer> delete(@NotNull UserDeletionReason var1);

    default public Optional<Punishment> getPunishment(@NotNull UUID punishmentUuid) {
        return this.getPunishments(new PunishmentType[0]).stream().filter(punishment -> punishment.getPunishmentUuid().equals(punishmentUuid)).findFirst();
    }

    @NotNull
    public Locale getLocale();

    @NotNull
    public Optional<NecrifyTemplateStage> getCurrentTemplateStage(@NotNull NecrifyTemplate var1);

    @NotNull
    public NecrifyTemplateStage getNextTemplateStage(@NotNull NecrifyTemplate var1);

    @NotNull
    public CompletableFuture<Punishment> punishModelled(@NotNull NecrifyTemplate var1);

    public CompletableFuture<Void> amnesty(@NotNull NecrifyTemplate var1, int var2);
}

