/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.api.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserLoadOrderCoordinator {
    private UserLoadOrderCoordinator() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    @NotNull
    public static List<Map<String, Object>> topologicalSort(@NotNull List<Map<String, Object>> nodes) {
        HashMap<UUID, Integer> inDegree = new HashMap<UUID, Integer>();
        HashMap graph = new HashMap();
        ArrayList<Map<String, Object>> sortedList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : nodes) {
            UUID nodeId = (UUID)map.get("punishmentUuid");
            UUID successorId = (UUID)map.get("successorId");
            inDegree.putIfAbsent(nodeId, 0);
            graph.putIfAbsent(nodeId, new ArrayList());
            if (successorId == null) continue;
            ((List)graph.get(nodeId)).add(successorId);
            inDegree.put(successorId, inDegree.getOrDefault(successorId, 0) + 1);
        }
        LinkedList<UUID> queue = new LinkedList<UUID>();
        for (UUID nodeId : inDegree.keySet()) {
            if ((Integer)inDegree.get(nodeId) != 0) continue;
            queue.add(nodeId);
        }
        while (!queue.isEmpty()) {
            UUID uUID = (UUID)queue.poll();
            sortedList.add(UserLoadOrderCoordinator.findNodeById(nodes, uUID));
            for (UUID neighbor : (List)graph.get(uUID)) {
                inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                if ((Integer)inDegree.get(neighbor) != 0) continue;
                queue.add(neighbor);
            }
        }
        if (sortedList.size() != nodes.size()) {
            throw new IllegalStateException("Graph has at least one cycle");
        }
        Collections.reverse(sortedList);
        return sortedList;
    }

    @Nullable
    private static Map<String, Object> findNodeById(List<Map<String, Object>> nodes, UUID nodeId) {
        for (Map<String, Object> node : nodes) {
            if (!nodeId.equals(node.get("punishmentUuid"))) continue;
            return node;
        }
        return null;
    }
}

