/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import de.jvstvshd.necrify.api.Necrify;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.PunishmentTypeRegistry;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.TemplateManager;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.commands.NecrifyCommand;
import de.jvstvshd.necrify.common.commands.NecrifyUserParser;
import de.jvstvshd.necrify.common.commands.PunishmentDurationParser;
import de.jvstvshd.necrify.common.commands.PunishmentParser;
import de.jvstvshd.necrify.common.commands.PunishmentTypeParser;
import de.jvstvshd.necrify.common.commands.TemplateParser;
import de.jvstvshd.necrify.common.commands.UserNotFoundParseException;
import de.jvstvshd.necrify.common.config.ConfigurationManager;
import de.jvstvshd.necrify.common.punishment.NecrifyKick;
import de.jvstvshd.necrify.common.punishment.NecrifyPunishmentFactory;
import de.jvstvshd.necrify.common.punishment.log.NecrifyPunishmentLog;
import de.jvstvshd.necrify.common.template.MinecraftTemplateManager;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.annotations.extractor.CommandExtractor;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.handling.ExceptionHandler;
import org.incendo.cloud.minecraft.extras.parser.ComponentParser;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.ParserRegistry;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.type.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class AbstractNecrifyPlugin
implements Necrify {
    public static final String VERSION = "1.2.3-SNAPSHOT";
    public static final String GIT_COMMIT = "83ca708";
    public static final String BUILD_NUMBER = "164";
    protected final ExecutorService executorService;
    protected final ConfigurationManager configurationManager;
    private final Cache<UUID, Punishment> historicalPunishmentCache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(10L)).build();
    private final Logger logger;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private TemplateManager templateManager = new MinecraftTemplateManager(this, this.miniMessage);

    public AbstractNecrifyPlugin(ExecutorService executorService, ConfigurationManager configurationManager, Logger logger) {
        this.executorService = executorService;
        this.configurationManager = configurationManager;
        this.logger = logger;
    }

    @Override
    @NotNull
    public ExecutorService getExecutor() {
        return this.executorService;
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public ExecutorService getService() {
        return this.getExecutor();
    }

    public final void registerFactories() {
        NecrifyPunishmentFactory factory = new NecrifyPunishmentFactory(this);
        for (StandardPunishmentType type : StandardPunishmentType.values()) {
            PunishmentTypeRegistry.registerType(type, factory);
        }
    }

    public final void registerCommands(CommandManager<NecrifyUser> manager, boolean topLevelCommands) {
        AnnotationParser parser = new AnnotationParser(manager, NecrifyUser.class);
        CommandExtractor oldExtractor = parser.commandExtractor();
        if (!topLevelCommands) {
            parser.commandExtractor(instance -> {
                ArrayList commands = new ArrayList(oldExtractor.extractCommands(instance));
                return commands.stream().filter(commandDescriptor -> commandDescriptor.commandToken().startsWith("necrify")).toList();
            });
        }
        manager.exceptionController().registerHandler(ArgumentParseException.class, context -> {
            Component component = this.getMessageProvider().prefixed(Component.text((String)((ArgumentParseException)context.exception()).getCause().getMessage()).color((TextColor)NamedTextColor.DARK_RED));
            ((NecrifyUser)context.context().sender()).sendMessage(component);
        });
        manager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(UserNotFoundParseException.class)).registerHandler(UserNotFoundParseException.class, context -> {
            Component component = this.getMessageProvider().provide("commands.general.not-found", new Component[]{Component.text((String)((UserNotFoundParseException)((Object)((Object)context.exception()))).playerName(), (TextColor)NamedTextColor.YELLOW)}).color((TextColor)NamedTextColor.RED);
            ((NecrifyUser)context.context().sender()).sendMessage(component);
        });
        manager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(PunishmentParser.PunishmentParseException.class)).registerHandler(PunishmentParser.PunishmentParseException.class, context -> {
            Component[] replacements = (Component[])Arrays.stream(((PunishmentParser.PunishmentParseException)context.exception()).getReplacements()).map(s -> Component.text((String)s, (TextColor)NamedTextColor.YELLOW)).toArray(Component[]::new);
            Component component = this.getMessageProvider().provide(((PunishmentParser.PunishmentParseException)context.exception()).getMessage(), replacements).color((TextColor)NamedTextColor.RED);
            ((NecrifyUser)context.context().sender()).sendMessage(component);
        });
        manager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(PunishmentDuration.Parser.ParseException.class)).registerHandler(PunishmentDuration.Parser.ParseException.class, context -> {
            Component component = this.getMessageProvider().provide("command.punishment.duration.invalid", new Component[]{Component.text((String)((PunishmentDuration.Parser.ParseException)context.exception()).getMessage(), (TextColor)NamedTextColor.YELLOW)}).color((TextColor)NamedTextColor.RED);
            ((NecrifyUser)context.context().sender()).sendMessage(component);
        });
        manager.exceptionController().registerHandler(ArgumentParseException.class, ExceptionHandler.unwrappingHandler(TemplateParser.ParseException.class)).registerHandler(TemplateParser.ParseException.class, context -> ((NecrifyUser)context.context().sender()).sendMessage("command.template.not-found", (TextColor)NamedTextColor.RED, new Component[]{Component.text((String)((TemplateParser.ParseException)context.exception()).getTemplate(), (TextColor)NamedTextColor.YELLOW)}));
        manager.exceptionController().registerHandler(CommandExecutionException.class, ExceptionHandler.unwrappingHandler(Throwable.class)).registerHandler(Throwable.class, context -> {
            this.logger.error("An internal error occurred while executing a command", context.exception());
            Component component = this.getMessageProvider().provide("error.internal", new Component[0]);
            ((NecrifyUser)context.context().sender()).sendMessage(component);
        });
        manager.captionRegistry().registerProvider((caption, user) -> {
            Component component = this.getMessageProvider().provide(caption.key(), user.getLocale(), new Component[0]);
            return PlainTextComponentSerializer.plainText().serialize(component);
        });
        ParserRegistry parserRegistry = manager.parserRegistry();
        parserRegistry.registerParser(ParserDescriptor.of((ArgumentParser)new NecrifyUserParser(this.getUserManager()), NecrifyUser.class));
        parserRegistry.registerParser(ComponentParser.componentParser((ComponentSerializer)this.miniMessage, (StringParser.StringMode)StringParser.StringMode.QUOTED));
        parserRegistry.registerParser(ParserDescriptor.of((ArgumentParser)new PunishmentDurationParser(this.getMessageProvider()), PunishmentDuration.class));
        parserRegistry.registerParser(ParserDescriptor.of((ArgumentParser)new PunishmentParser(this), Punishment.class));
        parserRegistry.registerParser(ParserDescriptor.of((ArgumentParser)new TemplateParser(this.getTemplateManager()), NecrifyTemplate.class));
        parserRegistry.registerParser(ParserDescriptor.of((ArgumentParser)new PunishmentTypeParser(), PunishmentType.class));
        NecrifyCommand commands = new NecrifyCommand(this);
        parser.parse(new Object[]{commands});
    }

    public String getDefaultReason(PunishmentType type) {
        return this.configurationManager.getConfiguration().getPunishmentConfigData().getPunishmentMessages().get(type.getId());
    }

    public boolean loadConfig() {
        try {
            this.configurationManager.load();
            if (this.configurationManager.getConfiguration().isWhitelistActivated()) {
                this.logger.info("Whitelist is activated. This means that nobody can join this server beside players you have explicitly allowed to join this server via /necrify user <player> whitelist (toggles current state).");
            }
        }
        catch (IOException e) {
            this.logger.error("Could not load configuration", (Throwable)e);
            this.logger.error("Aborting start-up");
            return false;
        }
        return true;
    }

    public static String buildInfo() {
        Object buildInfo = "v1.2.3-SNAPSHOT (running on commit 83ca708";
        if (!BUILD_NUMBER.equalsIgnoreCase("-1")) {
            buildInfo = (String)buildInfo + " build 164";
        }
        return (String)buildInfo + ")";
    }

    public ConfigurationManager getConfig() {
        return this.configurationManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public <T extends Punishment> T getHistoricalPunishment(UUID punishmentUuid) {
        Punishment cached = (Punishment)this.historicalPunishmentCache.getIfPresent((Object)punishmentUuid);
        if (cached != null) {
            return (T)cached;
        }
        NecrifyPunishmentLog log = new NecrifyPunishmentLog(this, punishmentUuid);
        if (log.load(false)) {
            Punishment result = log.getPunishment();
            if (result != null) {
                this.historicalPunishmentCache.put((Object)punishmentUuid, (Object)result);
                return (T)result;
            }
            return (T)log.getPunishment();
        }
        return null;
    }

    public <T extends Punishment> Optional<T> getCachedPunishment(UUID punishmentUuid) {
        for (NecrifyUser necrifyUser : this.getUserManager().getLoadedUsers()) {
            Optional<Punishment> punishment = necrifyUser.getPunishment(punishmentUuid);
            if (!punishment.isPresent()) continue;
            return punishment;
        }
        Punishment cachedHPunishment = (Punishment)this.historicalPunishmentCache.getIfPresent((Object)punishmentUuid);
        return Optional.ofNullable(cachedHPunishment);
    }

    public Cache<UUID, Punishment> getHistoricalPunishmentCache() {
        return this.historicalPunishmentCache;
    }

    @Override
    @NotNull
    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    @Override
    public void setTemplateManager(@NotNull TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public abstract NecrifyKick createKick(Component var1, NecrifyUser var2, UUID var3);

    public abstract Set<Pair<String, UUID>> getOnlinePlayers();

    @NotNull
    public abstract NecrifyUser getSystemUser();

    public abstract boolean isWhitelistActive();
}

