/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.template.TemplateManager;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserDeletionReason;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.commands.ComponentOrTemplate;
import de.jvstvshd.necrify.common.commands.PunishmentLogPaginationRowRenderer;
import de.jvstvshd.necrify.common.config.ConfigData;
import de.jvstvshd.necrify.common.template.MinecraftTemplateStage;
import de.jvstvshd.necrify.common.util.PunishmentHelper;
import de.jvstvshd.necrify.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.incendo.cloud.annotation.specifier.Greedy;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.Commands;
import org.incendo.cloud.annotations.Default;
import org.incendo.cloud.annotations.Flag;
import org.incendo.cloud.annotations.Permission;
import org.incendo.cloud.annotations.suggestion.Suggestions;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.type.tuple.Pair;
import org.slf4j.Logger;

public class NecrifyCommand {
    private final AbstractNecrifyPlugin plugin;
    private final MiniMessage miniMessage;
    private final Logger logger;
    private final MessageProvider provider;
    private final TemplateManager templateManager;
    private static final List<String> PUNISHMENT_COMMAND_OPTIONS = List.of("cancel", "remove", "info", "change", "log");
    private static final List<String> USER_COMMAND_OPTIONS = List.of("info", "delete", "whitelist");
    private static final List<String> TEMPLATE_COMMAND_OPTIONS = List.of("info", "delete");

    public NecrifyCommand(AbstractNecrifyPlugin plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.logger = plugin.getLogger();
        this.provider = plugin.getMessageProvider();
        this.templateManager = plugin.getTemplateManager();
    }

    @Commands(value={@Command(value="necrify ban <target> [reason]"), @Command(value="ban <target> [reason]")})
    @Permission(value={"necrify.command.ban", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void banCommand(NecrifyUser sender, @Argument(value="target", description="Player to ban", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="reason", description="Reason the user should be banned for", suggestions="suggestMiniMessageAndTemplate") @Greedy String templateOrReason) {
        this.infinitePunishmentCommand(sender, target, templateOrReason, target::banPermanent, "command.ban.success", StandardPunishmentType.PERMANENT_BAN);
    }

    @Commands(value={@Command(value="necrify mute <target> [reason]"), @Command(value="mute <target> [reason]")})
    @Permission(value={"necrify.command.mute", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void muteCommand(NecrifyUser sender, @Argument(value="target", description="Player to mute", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="reason", description="Reason the user should be muted for", suggestions="suggestMiniMessage") @Greedy String templateOrReason) {
        this.infinitePunishmentCommand(sender, target, templateOrReason, target::mutePermanent, "command.mute.success", StandardPunishmentType.PERMANENT_MUTE);
    }

    @Commands(value={@Command(value="necrify kick <target> [reason]"), @Command(value="kick <target> [reason]")})
    @Permission(value={"necrify.command.kick", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void kickCommand(NecrifyUser sender, @Argument(value="target", description="Player to kick", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="reason", description="Reason the user should be kicked for", suggestions="suggestMiniMessage") @Greedy String templateOrReason) {
        this.infinitePunishmentCommand(sender, target, templateOrReason, target::kick, "command.kick.success", StandardPunishmentType.KICK);
    }

    @Commands(value={@Command(value="necrify tempban <target> <duration> [reason]"), @Command(value="tempban <target> <duration> [reason]")})
    @Permission(value={"necrify.command.tempban", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void tempbanCommand(NecrifyUser sender, @Argument(value="target", description="Player to tempban", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="duration", description="Duration the user should be banned for") PunishmentDuration duration, @Argument(value="reason", description="Reason the user should be banned for", suggestions="suggestMiniMessage") @Greedy String reason) {
        Component finalReason = this.reasonOrDefaultTo(reason, StandardPunishmentType.TEMPORARY_BAN);
        target.ban(finalReason, duration).whenComplete((ban, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.tempban.success", (TextColor)NamedTextColor.GRAY, this.userReference(target), this.copyComponent(ban.getUuid().toString()).color((TextColor)NamedTextColor.YELLOW), finalReason, this.miniMessage(duration.expirationAsString(), new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            this.tryChainPunishments(sender, target, (Punishment)ban);
        });
    }

    @Commands(value={@Command(value="necrify tempmute <target> <duration> [reason]"), @Command(value="tempmute <target> <duration> [reason]")})
    @Permission(value={"necrify.command.tempmute", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void tempmuteCommand(NecrifyUser sender, @Argument(value="target", description="Player to tempmute", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="duration", description="Duration the user should be muted for") PunishmentDuration duration, @Argument(value="reason", description="Reason the user should be muted for", suggestions="suggestMiniMessage") @Greedy String reason) {
        Component finalReason = this.reasonOrDefaultTo(reason, StandardPunishmentType.TEMPORARY_MUTE);
        target.mute(finalReason, duration).whenComplete((mute, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.tempmute.success", (TextColor)NamedTextColor.GRAY, this.userReference(target), this.copyComponent(mute.getUuid().toString()).color((TextColor)NamedTextColor.YELLOW), finalReason, this.miniMessage(duration.expirationAsString(), new TagResolver[0]).color((TextColor)NamedTextColor.YELLOW));
            this.tryChainPunishments(sender, target, (Punishment)mute);
        });
    }

    @Commands(value={@Command(value="necrify unban <target>"), @Command(value="unban <target>")})
    @Permission(value={"necrify.command.unban", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void unbanCommand(NecrifyUser sender, @Argument(value="target", description="Player to unban") NecrifyUser target) {
        List<Punishment> punishments = target.getPunishments(StandardPunishmentType.TEMPORARY_BAN, StandardPunishmentType.PERMANENT_BAN);
        try {
            this.removePunishments(sender, punishments, "unban", "ban", "banned");
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    @Commands(value={@Command(value="necrify unmute <target>"), @Command(value="unmute <target>")})
    @Permission(value={"necrify.command.unmute", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void unmuteCommand(NecrifyUser sender, @Argument(value="target", description="Player to unmute", suggestions="suggestOnlinePlayers") NecrifyUser target) {
        List<Punishment> punishments = target.getPunishments(StandardPunishmentType.TEMPORARY_MUTE, StandardPunishmentType.PERMANENT_MUTE);
        this.removePunishments(sender, punishments, "unmute", "mute", "muted");
    }

    @Command(value="necrify punishment <punishmentId> [option]")
    @Permission(value={"necrify.command.punishment", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void punishmentCommand(NecrifyUser sender, @Argument(value="punishmentId", description="Punishment to manage") Punishment punishmentParsed, @Argument(value="option", description="Option to manage the punishment", suggestions="suggestPunishmentCommandOptions") @Default(value="info") String option, @Flag(value="chain", description="Another punishment to chain") Punishment otherPunishment, @Flag(value="page", description="Page to display") Integer pageArgument) {
        switch (option) {
            case "info": {
                sender.sendMessage(this.buildComponent(PunishmentHelper.buildPunishmentData(punishmentParsed, this.plugin.getMessageProvider())));
                break;
            }
            case "cancel": 
            case "remove": {
                try {
                    punishmentParsed.cancel().whenCompleteAsync((unused, th) -> {
                        if (th != null) {
                            this.logException(sender, (Throwable)th);
                            return;
                        }
                        sender.sendMessage(this.provider.provide("command.punishment.cancel.success", new Component[0]).color((TextColor)NamedTextColor.GREEN));
                    }, (Executor)this.plugin.getExecutor());
                }
                catch (UnsupportedOperationException e) {
                    sender.sendMessage((Component)Component.text((String)"Error: Punishment can not be deleted, maybe because it is not active anymore.", (TextColor)NamedTextColor.RED));
                }
                break;
            }
            case "change": {
                sender.sendMessage(this.miniMessage("Soon (TM)", new TagResolver[0]).color((TextColor)NamedTextColor.LIGHT_PURPLE));
                break;
            }
            case "chain": {
                if (!punishmentParsed.getType().getRelatedTypes().contains(otherPunishment.getType())) {
                    sender.sendMessage(this.provider.provide("command.punishment.chain.unrelated-types", new Component[0]).color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (!punishmentParsed.getUser().equals(otherPunishment.getUser())) {
                    sender.sendMessage(this.provider.provide("command.punishment.chain.user-mismatch", new Component[0]).color((TextColor)NamedTextColor.RED));
                    return;
                }
                if (Util.circularSuccessionChain(punishmentParsed, otherPunishment)) {
                    sender.sendMessage(this.provider.provide("command.punishment.circular-chain", new Component[0]).color((TextColor)NamedTextColor.RED));
                    return;
                }
                punishmentParsed.setSuccessor(otherPunishment).whenComplete((unused, th) -> {
                    if (th != null) {
                        this.logException(sender, (Throwable)th);
                        return;
                    }
                    sender.sendMessage(this.provider.provide("command.punishment.chain.success", new Component[0]).color((TextColor)NamedTextColor.GREEN));
                });
                break;
            }
            case "log": {
                int page = pageArgument == null ? 1 : pageArgument;
                punishmentParsed.loadPunishmentLog().whenComplete((punishmentLog, throwable) -> {
                    if (throwable != null) {
                        this.logException(sender, (Throwable)throwable);
                        return;
                    }
                    List paginator = Pagination.builder().width(42).resultsPerPage(5).build((Component)Component.text((String)"Necrify Punishment Log"), (Pagination.Renderer.RowRenderer)new PunishmentLogPaginationRowRenderer(this.miniMessage, this.plugin), functionPage -> "/necrify punishment " + String.valueOf(punishmentParsed.getPunishmentUuid()) + " log --page " + functionPage).render(punishmentLog.getEntries(), page);
                    for (Component component : paginator) {
                        sender.sendMessage(component);
                    }
                });
                break;
            }
            default: {
                sender.sendMessage(this.unknownOption(option, PUNISHMENT_COMMAND_OPTIONS));
            }
        }
    }

    @Command(value="necrify user <target> [option]")
    @Permission(value={"necrify.command.user", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void userCommand(NecrifyUser sender, @Argument(value="target", description="Player to manage", suggestions="suggestOnlinePlayers") NecrifyUser target, @Argument(value="option", description="Option to manage the player", suggestions="suggestUserCommandOptions") @Default(value="info") String option) {
        switch (option) {
            case "info": {
                List punishments = target.getPunishments(new PunishmentType[0]);
                sender.sendMessage(this.whitelistStatus(target));
                sender.sendMessage(this.provider.provide("command.user.overview", new Component[]{Util.copyComponent(Objects.requireNonNullElse(target.getUsername(), "null"), this.provider).color((TextColor)NamedTextColor.YELLOW), Util.copyComponent(target.getUuid().toString(), this.provider).color((TextColor)NamedTextColor.YELLOW), Component.text((int)punishments.size())}).color((TextColor)NamedTextColor.GRAY));
                for (Punishment punishment : punishments) {
                    if (punishment.getPredecessor() != null) continue;
                    Component component = this.buildComponent(PunishmentHelper.buildPunishmentData(punishment, this.plugin.getMessageProvider()));
                    sender.sendMessage(component);
                }
                break;
            }
            case "delete": {
                target.delete(UserDeletionReason.USER_DELETED).whenComplete((integer, throwable) -> {
                    if (throwable != null) {
                        this.logException(sender, (Throwable)throwable);
                        return;
                    }
                    sender.sendMessage(this.provider.provide("command.user.delete.success", Component.text((int)integer).color((TextColor)NamedTextColor.YELLOW)).color((TextColor)NamedTextColor.RED));
                });
                break;
            }
            case "whitelist": {
                boolean newState = target.isWhitelisted();
                target.setWhitelisted(!newState).whenComplete((unused, throwable) -> {
                    if (throwable != null) {
                        this.logException(sender, (Throwable)throwable);
                        return;
                    }
                    sender.sendMessage(this.provider.provide("command.whitelist.success", new Component[0]).color((TextColor)NamedTextColor.GREEN));
                    sender.sendMessage(this.whitelistStatus(target));
                });
                break;
            }
            default: {
                sender.sendMessage(this.unknownOption(option, USER_COMMAND_OPTIONS));
            }
        }
    }

    @Command(value="necrify reload")
    @Permission(value={"necrify.command.reload", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void reloadCommand(NecrifyUser sender) {
        try {
            sender.sendMessage(this.provider.provide("command.reload.start", new Component[0]).color((TextColor)NamedTextColor.GRAY));
            long start = System.currentTimeMillis();
            ConfigData old = this.plugin.getConfig().getConfiguration();
            this.plugin.getConfig().load();
            ConfigData reloaded = this.plugin.getConfig().getConfiguration();
            if (!old.isWhitelistActivated() && reloaded.isWhitelistActivated()) {
                Util.executeAsync(() -> {
                    this.logger.info("Whitelist activated. Kicking all players who aren't allowed here anymore. This may take some time...");
                    long startKick = System.currentTimeMillis();
                    Set<Pair<String, UUID>> onlinePlayers = this.plugin.getOnlinePlayers();
                    onlinePlayers.forEach(pair -> {
                        try {
                            NecrifyUser user = this.plugin.getUserManager().loadOrCreateUser((UUID)pair.second()).join().get();
                            if (!user.isWhitelisted()) {
                                user.kick(this.provider.provide("whitelist.removed", new Component[0]).color((TextColor)NamedTextColor.RED)).join();
                            }
                        }
                        catch (Exception e) {
                            this.logException(e);
                        }
                    });
                    this.logger.info("Kicked all non-whitelisted players. Took {} seconds.", (Object)((double)(System.currentTimeMillis() - startKick) / 1000.0));
                    return null;
                }, this.plugin.getExecutor());
            }
            String took = String.format("%.2f", (double)(System.currentTimeMillis() - start) / 1000.0);
            sender.sendMessage(this.provider.provide("command.reload.success", Component.text((String)took).color((TextColor)NamedTextColor.YELLOW)).color((TextColor)NamedTextColor.GREEN));
        }
        catch (IOException e) {
            this.logException(sender, e);
            sender.sendMessage(this.provider.provide("command.reload.failure", new Component[0]).color((TextColor)NamedTextColor.RED));
        }
    }

    @Command(value="necrify whitelist [option]")
    @Permission(value={"necrify.command.whitelist", "necrify.admin"}, mode=Permission.Mode.ANY_OF)
    public void whitelistCommand(NecrifyUser sender, @Argument(value="option", description="Option to retrieve the whitelist's status") @Default(value="status") String option) {
        boolean whitelist = this.plugin.isWhitelistActive();
        String activeState = whitelist ? "active" : "inactive";
        sender.sendMessage(this.provider.provide("command.whitelist." + activeState, new Component[0]).color((TextColor)NamedTextColor.GRAY));
        sender.sendMessage(this.provider.provide("whitelist.change-in-config", new Component[0]));
    }

    @Command(value="necrify createtemplate <name>")
    public void createTemplateCommand(NecrifyUser sender, @Argument(value="name", description="Name of the template") String name) {
        if (this.templateManager.getTemplate(name).isPresent()) {
            sender.sendMessage("command.template.create.already-exists", (TextColor)NamedTextColor.RED, new Component[0]);
            return;
        }
        this.templateManager.createTemplate(name).whenComplete((necrifyTemplate, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.template.create.success", (TextColor)NamedTextColor.GREEN, new Component[]{Component.text((String)name, (TextColor)NamedTextColor.YELLOW)});
        });
    }

    @Command(value="necrify template <name>")
    public void templateInfoCommand(NecrifyUser sender, @Argument(value="name", description="Description") NecrifyTemplate template, @Flag(value="page") Integer pageArgument) {
        int page = pageArgument == null ? 1 : pageArgument;
        sender.sendMessage("command.template.manage.info", (TextColor)NamedTextColor.GRAY, new Component[]{Component.text((String)template.name(), (TextColor)NamedTextColor.YELLOW), Component.text((int)template.stages().size(), (TextColor)NamedTextColor.YELLOW)});
        Pagination.Renderer.RowRenderer rowRenderer = (stage, index) -> List.of(PunishmentHelper.buildTemplateStageInformation(Objects.requireNonNull(stage), this.provider));
        List components = Pagination.builder().width(42).resultsPerPage(5).build((Component)Component.text((String)template.name(), (TextColor)NamedTextColor.YELLOW), rowRenderer, functionPage -> "/necrify template " + template.name() + " --page " + functionPage).render(template.stages(), page);
        for (Component component : components) {
            sender.sendMessage(component);
        }
    }

    @Command(value="necrify template <name> delete")
    public void templateDeleteCommand(NecrifyUser sender, @Argument(value="name", description="Name of the template") NecrifyTemplate template) {
        template.delete().whenComplete((integer, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.template.delete.success", (TextColor)NamedTextColor.GREEN, new Component[]{Component.text((String)template.name(), (TextColor)NamedTextColor.YELLOW), Component.text((int)integer, (TextColor)NamedTextColor.YELLOW)});
        });
    }

    @Command(value="necrify template <name> addstage <duration> <type> <reason>")
    public void templateAddStageCommand(NecrifyUser sender, @Argument(value="name") NecrifyTemplate template, @Argument(value="duration") PunishmentDuration duration, @Argument(value="type") PunishmentType punishmentType, @Argument(value="reason", suggestions="suggestMiniMessage") @Greedy String reasonString) {
        StandardPunishmentType standardPunishmentType;
        Component reason = this.miniMessage(reasonString, new TagResolver[0]);
        if (punishmentType instanceof StandardPunishmentType && (standardPunishmentType = (StandardPunishmentType)punishmentType).isPermanent()) {
            duration = PunishmentDuration.PERMANENT;
        }
        template.addStage(new MinecraftTemplateStage(template, punishmentType, duration, reason, template.stages().size(), this.plugin)).whenComplete((stage, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.template.stage.add.success", (TextColor)NamedTextColor.GREEN, new Component[0]);
        });
    }

    @Command(value="necrify template <name> removestage <index>")
    public void templateRemoveStageCommand(NecrifyUser sender, @Argument(value="name") NecrifyTemplate template, @Argument(value="index") int index) {
        template.getStage(index - 1).delete().whenCompleteAsync((integer, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.template.stage.remove.success", (TextColor)NamedTextColor.GREEN, new Component[0]);
        });
    }

    @Command(value="necrify template <name> apply <user>")
    public void templateApplyCommand(NecrifyUser sender, @Argument(value="name") NecrifyTemplate template, @Argument(value="user", suggestions="suggestOnlinePlayers") NecrifyUser user) {
        user.punishModelled(template).whenComplete((punishment, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage("command.template.apply.success", (TextColor)NamedTextColor.GREEN, new Component[]{this.userReference(user), PunishmentHelper.buildPunishmentTypeInformation(punishment.getType(), this.provider), punishment.getReason(), Component.text((String)PunishmentDuration.ofPunishment(punishment).remainingDuration()), Component.text((String)template.name(), (TextColor)NamedTextColor.YELLOW), this.copyComponent(punishment.getUuid().toString()).color((TextColor)NamedTextColor.YELLOW)});
        });
    }

    @Command(value="necrify template <name> amnesty <target>")
    public void templateAmnestyCommand(NecrifyUser sender, @Argument(value="name") NecrifyTemplate template, @Argument(value="target", suggestions="suggestOnlinePlayers") NecrifyUser target, @Flag(value="to") @Default(value="0") Integer toStage) {
        int stageIndex = toStage == null ? 0 : Math.min(Math.max(toStage, 1), template.stages().size()) - 1;
        target.amnesty(template, stageIndex).whenComplete((unused, throwable) -> sender.sendMessage("command.template.amnesty.success", (TextColor)NamedTextColor.GREEN, new Component[0]));
    }

    @Command(value="necrify template <name> state <target>")
    public void templateStateCommand(NecrifyUser sender, @Argument(value="name") NecrifyTemplate template, @Argument(value="target", suggestions="suggestOnlinePlayers") NecrifyUser target) {
        Optional<NecrifyTemplateStage> stageOptional = target.getCurrentTemplateStage(template);
        if (stageOptional.isEmpty()) {
            sender.sendMessage("command.template.state.no-stage", (TextColor)NamedTextColor.RED, new Component[0]);
            return;
        }
        NecrifyTemplateStage currentStage = stageOptional.get();
        NecrifyTemplateStage nextStage = currentStage.nextOrThis();
        sender.sendMessage("command.template.state.text", (TextColor)NamedTextColor.GRAY, new Component[]{Component.text((String)template.name(), (TextColor)NamedTextColor.YELLOW), this.userReference(target), Component.text((int)(currentStage.index() + 1), (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)PunishmentHelper.buildTemplateStageInformation(currentStage, this.provider))), Component.text((int)(nextStage.index() + 1), (TextColor)NamedTextColor.YELLOW).hoverEvent((HoverEventSource)HoverEvent.showText((Component)PunishmentHelper.buildTemplateStageInformation(nextStage, this.provider)))});
    }

    @Suggestions(value="suggestOnlinePlayers")
    public List<? extends Suggestion> suggestNames(CommandContext<NecrifyUser> context, CommandInput input) {
        return this.plugin.getOnlinePlayers().stream().filter(pair -> ((String)pair.first()).toLowerCase(Locale.ROOT).startsWith(input.peekString().toLowerCase(Locale.ROOT))).map(pair -> {
            Component select = this.provider.provide("suggestion.select-player", ((NecrifyUser)context.sender()).getLocale(), false, this.miniMessage("<yellow>(<name>/<uuid>)</yellow>", new TagResolver[]{Placeholder.parsed((String)"name", (String)((String)pair.first())), Placeholder.parsed((String)"uuid", (String)((UUID)pair.second()).toString())})).color((TextColor)NamedTextColor.RED);
            return ComponentTooltipSuggestion.suggestion((String)((String)pair.first()), (Component)select);
        }).toList();
    }

    @Suggestions(value="suggestMiniMessage")
    public List<? extends Suggestion> suggestMiniMessage(CommandContext<NecrifyUser> context, CommandInput input) {
        return Collections.singletonList(ComponentTooltipSuggestion.suggestion((String)(input.remainingInput() + " (" + this.provider.provideString("suggestion.hover-over-me", ((NecrifyUser)context.sender()).getLocale(), false, new Component[0]) + ")"), (Component)this.miniMessage(input.remainingInput(), new TagResolver[0])));
    }

    @Suggestions(value="suggestMiniMessageAndTemplate")
    public List<? extends Suggestion> suggestMiniMessageAndTemplate(CommandContext<NecrifyUser> context, CommandInput input) {
        ArrayList<? extends Suggestion> suggestions = new ArrayList<Suggestion>(this.suggestMiniMessage(context, input));
        suggestions.addAll(0, this.templateManager.getTemplates().stream().filter(template -> template.name().toLowerCase().startsWith(input.peekString().toLowerCase())).map(template -> ComponentTooltipSuggestion.suggestion((String)template.name(), (Component)MiniMessage.miniMessage().deserialize((Object)template.name()))).toList());
        return suggestions;
    }

    @Suggestions(value="suggestPunishmentCommandOptions")
    public List<? extends Suggestion> suggestPunishmentCommandOptions(CommandContext<NecrifyUser> context, CommandInput input) {
        return PUNISHMENT_COMMAND_OPTIONS.stream().filter(option -> option.toLowerCase().startsWith(input.peekString().toLowerCase())).map(option -> ComponentTooltipSuggestion.suggestion((String)option, (Component)this.miniMessage((String)option, new TagResolver[0]))).toList();
    }

    @Suggestions(value="suggestUserCommandOptions")
    public List<? extends Suggestion> suggestUserCommandOptions(CommandContext<NecrifyUser> context, CommandInput input) {
        return USER_COMMAND_OPTIONS.stream().filter(option -> option.toLowerCase().startsWith(input.peekString().toLowerCase())).map(option -> ComponentTooltipSuggestion.suggestion((String)option, (Component)this.miniMessage((String)option, new TagResolver[0]))).toList();
    }

    @Suggestions(value="suggestTemplateCommandOptions")
    public List<? extends Suggestion> suggestTemplateCommandOptions(CommandContext<NecrifyUser> context, CommandInput input) {
        return TEMPLATE_COMMAND_OPTIONS.stream().filter(option -> option.toLowerCase().startsWith(input.peekString().toLowerCase())).map(option -> ComponentTooltipSuggestion.suggestion((String)option, (Component)this.miniMessage((String)option, new TagResolver[0]))).toList();
    }

    public void infinitePunishmentCommand(NecrifyUser sender, NecrifyUser target, String templateOrReasonString, Function<Component, CompletableFuture<? extends Punishment>> reasonExecution, String successString, StandardPunishmentType defaultReasonType) {
        CompletableFuture<Punishment> punishmentFuture;
        ComponentOrTemplate templateOrReason = ComponentOrTemplate.fromString(templateOrReasonString, this.templateManager);
        if (templateOrReason.template().isPresent()) {
            punishmentFuture = target.punishModelled(templateOrReason.template().get());
        } else if (templateOrReason.component().isPresent()) {
            Component finalReason = this.reasonOrDefaultTo(templateOrReason.component().get(), defaultReasonType);
            punishmentFuture = reasonExecution.apply(finalReason);
        } else {
            throw new IllegalArgumentException("No reason or template provided");
        }
        punishmentFuture.whenComplete((punishment, throwable) -> {
            if (throwable != null) {
                this.logException(sender, (Throwable)throwable);
                return;
            }
            sender.sendMessage(successString, (TextColor)NamedTextColor.GRAY, this.userReference(target), this.copyComponent(punishment.getUuid().toString()).color((TextColor)NamedTextColor.YELLOW), punishment.getReason());
        });
    }

    private void removePunishments(NecrifyUser source, List<Punishment> punishments, String ... values) {
        if (punishments.isEmpty()) {
            source.sendMessage(this.plugin.getMessageProvider().provide("command.punishment.not-" + values[2], new Component[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (punishments.size() > 1) {
            source.sendMessage(this.plugin.getMessageProvider().provide("command." + values[0] + ".multiple-" + values[1] + "s", new Component[0]).color((TextColor)NamedTextColor.YELLOW));
            for (Punishment punishment : punishments) {
                if (punishment.getPredecessor() != null) continue;
                source.sendMessage(this.buildComponent(PunishmentHelper.buildPunishmentData(punishment, this.plugin.getMessageProvider())));
            }
        } else {
            Punishment punishment = punishments.getFirst();
            try {
                punishment.cancel().whenCompleteAsync((unused, th) -> {
                    if (th != null) {
                        this.logException(source, (Throwable)th);
                        this.plugin.getLogger().error("An error occurred while removing punishment {} for player {}", new Object[]{punishment.getPunishmentUuid(), punishment.getUser().getUsername(), th});
                        source.sendMessage(this.plugin.getMessageProvider().internalError());
                        return;
                    }
                    source.sendMessage(this.plugin.getMessageProvider().provide("command." + values[0] + ".success", new Component[0]).color((TextColor)NamedTextColor.GREEN));
                }, (Executor)this.plugin.getExecutor());
            }
            catch (Exception e) {
                this.logException(source, e);
            }
        }
    }

    private void tryChainPunishments(NecrifyUser sender, NecrifyUser target, Punishment newPunishment) {
        List<PunishmentType> types = newPunishment.getType().getRelatedTypes();
        List<Punishment> matchingPunishments = target.getPunishments(types.toArray(new PunishmentType[0])).stream().filter(punishment -> !punishment.equals(newPunishment)).toList();
        if (matchingPunishments.isEmpty()) {
            return;
        }
        List<Punishment> unchainedPunishments = matchingPunishments.stream().filter(punishment -> !punishment.hasSuccessor()).toList();
        if (unchainedPunishments.isEmpty()) {
            throw new IllegalStateException("No unchained punishments found. Did you forget to remove a reference?");
        }
        sender.sendMessage(this.provider.provide("command.punishment.chain.info", new Component[0]).color((TextColor)NamedTextColor.GRAY));
        for (Punishment unchainedPunishment : unchainedPunishments) {
            sender.sendMessage(this.provider.provide("command.punishment.chain", Component.text((String)unchainedPunishment.getPunishmentUuid().toString()).color((TextColor)NamedTextColor.YELLOW)).color((TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)("/necrify punishment " + unchainedPunishment.getPunishmentUuid().toString().toLowerCase(Locale.ROOT) + " chain --chain " + newPunishment.getPunishmentUuid().toString().toLowerCase(Locale.ROOT)))).hoverEvent(op -> HoverEvent.showText((Component)this.provider.provide("command.punishment.chain", new Component[0]).color((TextColor)NamedTextColor.GREEN))));
        }
    }

    private Component buildComponent(Component dataComponent) {
        return dataComponent;
    }

    private Component reasonOrDefaultTo(String reason, StandardPunishmentType type) {
        return this.miniMessage(reason == null ? this.plugin.getDefaultReason(type) : reason, new TagResolver[0]);
    }

    private Component userReference(NecrifyUser user) {
        return ((TextComponent)Component.text((String)this.getUsername(user), (TextColor)NamedTextColor.YELLOW).clickEvent(ClickEvent.runCommand((String)("/necrify user " + String.valueOf(user.getUuid()) + " info")))).hoverEvent(op -> HoverEvent.showText((Component)this.provider.provide("commands.general.view-user-info", false, new Component[]{Component.text((String)this.getUsername(user), (TextColor)NamedTextColor.YELLOW)}).color((TextColor)NamedTextColor.GREEN)));
    }

    private String getUsername(NecrifyUser user) {
        return Objects.requireNonNullElse(user.getUsername(), user.getUuid().toString());
    }

    private Component miniMessage(String message, TagResolver ... resolvers) {
        return this.miniMessage.deserialize(message, resolvers);
    }

    public TextComponent copyComponent(String text) {
        return (TextComponent)((TextComponent)Component.text((String)text).clickEvent(ClickEvent.suggestCommand((String)text))).hoverEvent(op -> HoverEvent.showText((Component)this.plugin.getMessageProvider().provide("commands.general.copy", new Component[0]).color((TextColor)NamedTextColor.GREEN)));
    }

    private Component whitelistStatus(NecrifyUser user) {
        boolean whitelisted = user.isWhitelisted();
        return this.provider.provide("command.whitelist.status", Component.text((String)Objects.requireNonNullElse(user.getUsername(), this.provider.provideString("user.unknown", user.getLocale(), new Component[0]))).color((TextColor)NamedTextColor.YELLOW), this.provider.provide("whitelist.status." + (whitelisted ? "whitelisted" : "disallowed"), false, new Component[0]).color((TextColor)(whitelisted ? NamedTextColor.GREEN : NamedTextColor.RED))).color((TextColor)NamedTextColor.GRAY);
    }

    private Component unknownOption(String option, List<String> options) {
        return this.provider.provide("commands.general.unknown-option", Component.text((String)option).color((TextColor)NamedTextColor.RED), Component.text((String)String.join((CharSequence)", ", options)).color((TextColor)NamedTextColor.YELLOW)).color((TextColor)NamedTextColor.GRAY);
    }

    private void logException(Throwable throwable) {
        this.logger.error("An error occurred while executing a command", throwable);
    }

    private void logException(NecrifyUser sender, Throwable throwable) {
        this.logger.error("An error occurred while executing a command for player {} ({})", new Object[]{sender.getUsername(), sender.getUuid(), throwable});
        sender.sendErrorMessage();
    }
}

