/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserManager;
import de.jvstvshd.necrify.common.commands.UserNotFoundParseException;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;

public class NecrifyUserParser
implements ArgumentParser.FutureArgumentParser<NecrifyUser, NecrifyUser> {
    private final UserManager userManager;

    public NecrifyUserParser(UserManager userManager) {
        this.userManager = userManager;
    }

    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<NecrifyUser>> parseFuture(@NonNull CommandContext<NecrifyUser> commandContext, @NonNull CommandInput commandInput) {
        String target = commandInput.peekString();
        return this.userManager.loadOrCreateUser(target).handle((necrifyUser, throwable) -> {
            if (throwable != null) {
                return ArgumentParseResult.failure((Throwable)throwable);
            }
            if (necrifyUser.isPresent()) {
                commandInput.readString();
                return ArgumentParseResult.success((Object)((NecrifyUser)necrifyUser.get()));
            }
            return ArgumentParseResult.failure((Throwable)((Object)new UserNotFoundParseException(NecrifyUser.class, commandContext, target)));
        });
    }
}

