/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.SuggestionProvider;

public class PunishmentDurationParser
implements ArgumentParser<NecrifyUser, PunishmentDuration> {
    private final MessageProvider provider;

    public PunishmentDurationParser(MessageProvider provider) {
        this.provider = provider;
    }

    public @NonNull ArgumentParseResult<@NonNull PunishmentDuration> parse(@NonNull CommandContext<@NonNull NecrifyUser> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.peekString();
        if (input.endsWith("(hover over me)")) {
            input = input.substring(0, input.length() - " (hover over me)".length());
        }
        try {
            PunishmentDuration duration = PunishmentDuration.parse(input);
            commandInput.readString();
            return ArgumentParseResult.success((Object)duration);
        }
        catch (PunishmentDuration.Parser.ParseException e) {
            return ArgumentParseResult.failure((Throwable)e);
        }
    }

    public @NonNull SuggestionProvider<NecrifyUser> suggestionProvider() {
        MessageProvider unprefixedProvider = this.provider.autoPrefixed(false);
        return (context, input) -> {
            ComponentTooltipSuggestion suggestion;
            String string = input.peekString();
            String hoverOverMe = " (" + unprefixedProvider.provideString("suggestion.hover-over-me", ((NecrifyUser)context.sender()).getLocale(), new Component[0]).trim() + ")";
            try {
                PunishmentDuration duration = PunishmentDuration.parse(string);
                String expiration = duration.expirationAsString();
                String correct = unprefixedProvider.provideString("suggestion.correct", ((NecrifyUser)context.sender()).getLocale(), new Component[0]);
                String until = unprefixedProvider.provideString("suggestion.until", ((NecrifyUser)context.sender()).getLocale(), new Component[0]) + " ";
                suggestion = ComponentTooltipSuggestion.suggestion((String)(string + " | " + correct + hoverOverMe), (Component)MiniMessage.miniMessage().deserialize((Object)("<green>" + until + expiration)));
            }
            catch (PunishmentDuration.Parser.ParseException e) {
                String incorrect = unprefixedProvider.provideString("suggestion.incorrect", ((NecrifyUser)context.sender()).getLocale(), new Component[0]);
                String invalidDuration = unprefixedProvider.provideString("suggestion.invalid-duration", ((NecrifyUser)context.sender()).getLocale(), new Component[0]) + " ";
                suggestion = ComponentTooltipSuggestion.suggestion((String)(string + " | " + incorrect + hoverOverMe), (Component)MiniMessage.miniMessage().deserialize((Object)("<red>" + invalidDuration + e.getMessage())));
            }
            return CompletableFuture.completedFuture(List.of(suggestion));
        };
    }
}

