/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogAction;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PunishmentLogPaginationRowRenderer
implements Pagination.Renderer.RowRenderer<PunishmentLogEntry> {
    private final MiniMessage miniMessage;
    private final MessageProvider messageProvider;
    private final AbstractNecrifyPlugin plugin;

    public PunishmentLogPaginationRowRenderer(MiniMessage miniMessage, AbstractNecrifyPlugin plugin) {
        this.miniMessage = miniMessage;
        this.messageProvider = plugin.getMessageProvider().autoPrefixed(false);
        this.plugin = plugin;
    }

    @NotNull
    public Collection<Component> renderRow(@Nullable PunishmentLogEntry value, int index) {
        try {
            Component change;
            if (value == null) {
                return List.of(Component.text((String)"null"));
            }
            Punishment punishment = value.punishment();
            PunishmentLogAction action = value.action();
            if (action == PunishmentLogAction.INFORMATION) {
                return List.of(((TextComponent.Builder)Component.text().append(new Component[]{this.messageProvider.prefix(), Component.text((String)(value.index() + 1 + ". "), (TextColor)NamedTextColor.GOLD), this.miniMessage.deserialize((Object)"<gray>Information logged internally.")})).build());
            }
            if (action == PunishmentLogAction.CREATED) {
                change = this.messageProvider.provide("log.punishment.created", false, punishment.getReason()).color((TextColor)NamedTextColor.GRAY);
            } else if (action == PunishmentLogAction.REMOVED) {
                change = this.messageProvider.provide("log.punishment.removed", false, punishment.getReason()).color((TextColor)NamedTextColor.GRAY);
            } else {
                String actionName;
                Function<PunishmentLogEntry, String> acquire;
                if (action == PunishmentLogAction.CHANGE_REASON) {
                    acquire = entry -> (String)this.miniMessage.serialize(entry.reason());
                    actionName = "log.change-reason";
                } else if (action == PunishmentLogAction.CHANGE_DURATION) {
                    acquire = entry -> entry.duration().toString();
                    actionName = "log.change-duration";
                } else if (action == PunishmentLogAction.CHANGE_PREDECESSOR) {
                    acquire = entry -> entry.predecessor() == null ? "none" : entry.predecessor().getUuid().toString();
                    actionName = "log.change-predecessor";
                } else if (action == PunishmentLogAction.CHANGE_SUCCESSOR) {
                    acquire = entry -> entry.successor() == null ? "none" : entry.successor().getUuid().toString();
                    actionName = "log.change-successor";
                } else if (action == PunishmentLogAction.CHANGE_TIME) {
                    acquire = entry -> Util.dtf.format(entry.beginsAt()) + " - " + Util.dtf.format(entry.duration().expiration());
                    actionName = "log.change-time";
                } else {
                    return List.of();
                }
                Component actionComponent = this.messageProvider.provide(actionName, false, new Component[0]).color((TextColor)NamedTextColor.LIGHT_PURPLE);
                change = ((TextComponent.Builder)Component.text().append(new Component[]{actionComponent, Component.space(), Component.text((String)acquire.apply(value.previousOrThis()), (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH}), Component.text((String)" -> ", (TextColor)NamedTextColor.YELLOW), Component.text((String)acquire.apply(value), (TextColor)NamedTextColor.GREEN)})).build();
            }
            Component username = value.actor() == null ? this.messageProvider.provide("user.unknown", false, new Component[0]) : Component.text((String)(value.actor().getUsername() == null ? value.actor().getUuid().toString() : value.actor().getUsername()));
            Component usernameComponent = Util.copyComponent(username.color((TextColor)NamedTextColor.YELLOW), username, this.messageProvider);
            TextComponent timeComponent = (TextComponent)Component.text((String)Util.dtf.format(value.instant())).color((TextColor)NamedTextColor.YELLOW);
            return List.of(((TextComponent.Builder)Component.text().append(new Component[]{this.messageProvider.prefix(), Component.text((String)(value.index() + 1 + ". "), (TextColor)NamedTextColor.GOLD), this.messageProvider.provide("log.executed-by-on", new Component[]{usernameComponent, timeComponent}).color((TextColor)NamedTextColor.GRAY), Component.space(), change})).build());
        }
        catch (Exception e) {
            this.plugin.getLogger().error("An error occurred while rendering a punishment log entry row.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

