/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PunishmentParser
implements ArgumentParser.FutureArgumentParser<NecrifyUser, Punishment> {
    private static final Logger log = LoggerFactory.getLogger(PunishmentParser.class);
    private final AbstractNecrifyPlugin necrify;

    public PunishmentParser(AbstractNecrifyPlugin necrify) {
        this.necrify = necrify;
    }

    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<Punishment>> parseFuture(@NonNull CommandContext<NecrifyUser> commandContext, @NonNull CommandInput commandInput) {
        String uuidString = commandInput.peekString();
        Optional<UUID> uuid = Util.fromString(uuidString);
        if (uuid.isEmpty()) {
            return CompletableFuture.completedFuture(ArgumentParseResult.failure((Throwable)new PunishmentParseException("command.punishment.uuid-parse-error", uuidString)));
        }
        return this.necrify.getPunishment(uuid.get()).handle((punishment, throwable) -> {
            if (throwable != null) {
                log.error("An error occurred while parsing a punishment.", throwable);
                return ArgumentParseResult.failure((Throwable)new PunishmentParseException("error.internal", new String[0]));
            }
            if (punishment.isPresent()) {
                commandInput.readString();
                return ArgumentParseResult.success((Object)((Punishment)punishment.get()));
            }
            return ArgumentParseResult.failure((Throwable)new PunishmentParseException("command.punishment.unknown-punishment-id", uuidString));
        });
    }

    public static class PunishmentParseException
    extends Exception {
        private final String[] replacements;

        public PunishmentParseException(String message, String ... replacements) {
            super(message);
            this.replacements = replacements;
        }

        public String[] getReplacements() {
            return this.replacements;
        }
    }
}

