/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.PunishmentTypeRegistry;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.SuggestionProvider;

public class PunishmentTypeParser
implements ArgumentParser<NecrifyUser, PunishmentType> {
    public @NonNull ArgumentParseResult<@NonNull PunishmentType> parse(@NonNull CommandContext<@NonNull NecrifyUser> commandContext, @NonNull CommandInput commandInput) {
        ArgumentParseResult success;
        String input = commandInput.peekString();
        try {
            success = ArgumentParseResult.success((Object)PunishmentTypeRegistry.getType(Integer.parseInt(input)));
        }
        catch (NumberFormatException e) {
            Optional<ArgumentParseResult> optional = PunishmentTypeRegistry.getPunishmentTypes().stream().filter(punishmentType -> punishmentType.getName().equalsIgnoreCase(input)).findFirst().map(ArgumentParseResult::success);
            if (optional.isPresent()) {
                success = optional.get();
            }
            return ArgumentParseResult.failure((Throwable)new PunishmentTypeNotFoundException(input));
        }
        commandInput.readString();
        return success;
    }

    public @NonNull SuggestionProvider<NecrifyUser> suggestionProvider() {
        return (context, input) -> CompletableFuture.completedFuture(PunishmentTypeRegistry.getPunishmentTypes().stream().filter(punishmentType -> punishmentType.getName().toLowerCase().startsWith(input.peekString().toLowerCase())).map(punishmentType -> ComponentTooltipSuggestion.suggestion((String)punishmentType.getName(), (Component)MiniMessage.miniMessage().deserialize((Object)punishmentType.getName()))).toList());
    }

    public static class PunishmentTypeNotFoundException
    extends Exception {
        private final String input;

        public PunishmentTypeNotFoundException(String input) {
            this.input = input;
        }
    }
}

