/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.commands;

import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.TemplateManager;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.suggestion.SuggestionProvider;

public class TemplateParser
implements ArgumentParser<NecrifyUser, NecrifyTemplate> {
    private final TemplateManager templateManager;

    public TemplateParser(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public @NonNull ArgumentParseResult<@NonNull NecrifyTemplate> parse(@NonNull CommandContext<@NonNull NecrifyUser> commandContext, @NonNull CommandInput commandInput) {
        Optional<NecrifyTemplate> template = this.templateManager.getTemplate(commandInput.peekString());
        return template.map(value -> {
            commandInput.readString();
            return ArgumentParseResult.success((Object)value);
        }).orElse(ArgumentParseResult.failure((Throwable)new ParseException(commandInput.peekString())));
    }

    public @NonNull SuggestionProvider<NecrifyUser> suggestionProvider() {
        return SuggestionProvider.blocking((context, input) -> this.templateManager.getTemplates().stream().filter(template -> template.name().toLowerCase().startsWith(input.peekString().toLowerCase())).map(template -> ComponentTooltipSuggestion.suggestion((String)template.name(), (Component)MiniMessage.miniMessage().deserialize((Object)template.name()))).toList());
    }

    public static class ParseException
    extends RuntimeException {
        private final String template;

        public ParseException(String template) {
            this.template = template;
        }

        public String getTemplate() {
            return this.template;
        }
    }
}

