/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.config;

import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.config.ConfigData;
import de.jvstvshd.necrify.lib.jackson.databind.ObjectMapper;
import de.jvstvshd.necrify.lib.jackson.databind.SequenceWriter;
import de.jvstvshd.necrify.lib.jackson.dataformat.yaml.YAMLFactory;
import de.jvstvshd.necrify.lib.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private final Path path;
    private final ObjectMapper objectMapper;
    private ConfigData configData = new ConfigData();

    public ConfigurationManager(Path path) {
        this.path = path;
        this.objectMapper = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
    }

    private void create() throws IOException {
        block17: {
            if (this.path.getParent() != null) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            boolean write = false;
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
                write = true;
            }
            try (FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);){
                if (channel.size() > 0L && !write) break block17;
                if (this.migrateConfig()) {
                    this.save();
                    return;
                }
                try (InputStream is = AbstractNecrifyPlugin.class.getResourceAsStream("/config.yml");){
                    if (is == null) {
                        throw new IOException("Could not find default config file.");
                    }
                    is.transferTo(Files.newOutputStream(this.path, new OpenOption[0]));
                }
            }
        }
    }

    private boolean migrateConfig() throws IOException {
        Path oldConfig = this.path.getParent().resolve("config.json");
        if (!Files.exists(oldConfig, new LinkOption[0])) {
            return false;
        }
        ConfigData oldConfigData = new ObjectMapper().readValue(oldConfig.toFile(), ConfigData.class);
        logger.info("Found old config file, migrating to new one....");
        this.configData = oldConfigData;
        logger.info("Successfully migrated old config file to {}", (Object)this.path.toAbsolutePath());
        return true;
    }

    public void load() throws IOException {
        this.create();
        this.configData = this.objectMapper.readValue(this.path.toFile(), ConfigData.class);
    }

    public void save() throws IOException {
        try (SequenceWriter writer = this.objectMapper.writerWithDefaultPrettyPrinter().writeValues(this.path.toFile());){
            writer.write(this.configData);
        }
    }

    public ConfigData getConfiguration() {
        return this.configData;
    }
}

