/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.config;

import de.chojo.sadu.core.databases.Database;
import de.chojo.sadu.mariadb.databases.MariaDb;
import de.chojo.sadu.mysql.databases.MySql;
import de.chojo.sadu.postgresql.databases.PostgreSql;
import de.chojo.sadu.sqlite.databases.SqLite;
import de.jvstvshd.necrify.lib.jackson.annotation.JsonAlias;
import de.jvstvshd.necrify.lib.jackson.annotation.JsonProperty;
import java.util.Locale;

public class DataBaseData {
    private final String host;
    private final String password;
    private final String username;
    private final String database;
    private final String port;
    @JsonProperty(value="sql-type")
    @JsonAlias(value={"sqlType"})
    private final String sqlType;
    @JsonProperty(value="max-pool-size")
    @JsonAlias(value={"maxPoolSize"})
    private final int maxPoolSize;
    @JsonProperty(value="min-idle")
    @JsonAlias(value={"minIdle"})
    private final int minIdle;
    @JsonProperty(value="postgres-schema")
    @JsonAlias(value={"postgresSchema"})
    private final String postgresSchema;
    @JsonProperty(value="enable-development-version-reset")
    private final boolean enableDevelopmentVersionReset;

    public DataBaseData(String host, String password, String username, String database, String port, String sqlType, int maxPoolSize, int minIdle, String postgresSchema) {
        this.host = host;
        this.password = password;
        this.username = username;
        this.database = database;
        this.port = port;
        this.sqlType = sqlType;
        this.maxPoolSize = maxPoolSize;
        this.minIdle = minIdle;
        this.postgresSchema = postgresSchema;
        this.enableDevelopmentVersionReset = false;
    }

    public DataBaseData(String host, String password, String username, String database, String port, String sqlType, int maxPoolSize, int minIdle, String postgresSchema, boolean enableDevelopmentVersionReset) {
        this.host = host;
        this.password = password;
        this.username = username;
        this.database = database;
        this.port = port;
        this.sqlType = sqlType;
        this.maxPoolSize = maxPoolSize;
        this.minIdle = minIdle;
        this.postgresSchema = postgresSchema;
        this.enableDevelopmentVersionReset = enableDevelopmentVersionReset;
    }

    public DataBaseData() {
        this("localhost", "password", "username", "necrify", "5432", "postgresql", 10, 5, "necrify", false);
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getPort() {
        return this.port;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public String getPostgresSchema() {
        return this.postgresSchema;
    }

    public boolean isEnableDevelopmentVersionReset() {
        return this.enableDevelopmentVersionReset;
    }

    public Database<?, ?> sqlType() {
        return switch (this.sqlType.toLowerCase(Locale.ROOT)) {
            case "mariadb" -> MariaDb.get();
            case "mysql" -> MySql.get();
            case "postgres", "postgresql" -> PostgreSql.get();
            case "sqlite" -> SqLite.get();
            default -> throw new IllegalStateException("Unexpected value: " + this.sqlType.toLowerCase(Locale.ROOT));
        };
    }
}

