/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.message;

import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleMessageProvider.class);
    private static final Component PREFIX = MiniMessage.miniMessage().deserialize((Object)"<grey>[<gradient:#ff1c08:#ff3f2e>Necrify</gradient>]</grey> ");
    private final Locale defaultLocale;
    private final boolean autoPrefixed;

    private static void registerFrom(Stream<Path> paths, TranslationRegistry registry) {
        paths.filter(path -> path.getFileName().toString().endsWith(".properties")).forEach(path -> {
            try {
                PropertyResourceBundle resource = new PropertyResourceBundle(Files.newInputStream(path, new OpenOption[0]));
                Locale locale = ResourceBundleMessageProvider.locale(path.getFileName().toString());
                registry.registerAll(locale, (ResourceBundle)resource, false);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while loading translation file {}", (Object)path.getFileName(), (Object)e);
            }
        });
    }

    private static Locale locale(String fileName) {
        return Objects.requireNonNull(Translator.parseLocale((String)fileName.substring(0, fileName.length() - ".properties".length())));
    }

    public ResourceBundleMessageProvider(@NotNull Locale defaultLocale) {
        this(defaultLocale, true);
    }

    private ResourceBundleMessageProvider(@NotNull Locale defaultLocale, boolean autoPrefixed) {
        this.defaultLocale = defaultLocale;
        this.autoPrefixed = autoPrefixed;
    }

    @Override
    @NotNull
    public Component provide(@NotNull String key, @Nullable Locale locale, boolean prefixed, Component ... args) {
        return GlobalTranslator.render((Component)this.provide(key, prefixed, args), (Locale)this.orDefault(locale));
    }

    @Override
    @NotNull
    public Component provide(@NotNull String key, boolean prefixed, Component ... args) {
        Objects.requireNonNull(key, "key may not be null");
        TranslatableComponent component = Component.translatable((String)key, (ComponentLike[])args);
        return prefixed ? this.prefixed(new Component[]{component}) : component;
    }

    @Override
    @NotNull
    public Component internalError(@Nullable Locale locale, boolean prefixed) {
        return this.provide("error.internal", locale, prefixed, new Component[0]).color((TextColor)NamedTextColor.DARK_RED);
    }

    @Override
    @NotNull
    public Component internalError(boolean prefixed) {
        return this.provide("error.internal", prefixed, new Component[0]).color((TextColor)NamedTextColor.DARK_RED);
    }

    @Override
    @NotNull
    public Component prefix() {
        return PREFIX;
    }

    @Override
    public boolean autoPrefixed() {
        return this.autoPrefixed;
    }

    @NotNull
    private Locale orDefault(@Nullable Locale input) {
        return input == null ? this.defaultLocale : input;
    }

    @Override
    public MessageProvider autoPrefixed(boolean autoPrefixed) {
        return new ResourceBundleMessageProvider(this.defaultLocale, autoPrefixed);
    }

    @Override
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public MessageProvider unprefixedProvider() {
        if (!this.autoPrefixed) {
            return this;
        }
        return new ResourceBundleMessageProvider(this.defaultLocale, false);
    }

    static {
        TranslationRegistry registry = TranslationRegistry.create((Key)Key.key((String)"necrify"));
        registry.defaultLocale(Locale.ENGLISH);
        Path baseDir = null;
        try {
            baseDir = Path.of("plugins", "necrify", "translations");
            if (!Files.exists(baseDir, new LinkOption[0])) {
                Files.createDirectories(baseDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while creating the translation directory", (Throwable)e);
        }
        try (Stream<Path> paths = Files.list(baseDir);){
            ArrayList<Path> registeredPaths = new ArrayList<Path>();
            try (JarFile jar = new JarFile(new File(AbstractNecrifyPlugin.class.getProtectionDomain().getCodeSource().getLocation().toURI()));){
                for (JarEntry translationEntry : jar.stream().filter(jarEntry -> jarEntry.getName().toLowerCase().contains("translations") && !jarEntry.isDirectory()).toList()) {
                    Path path = baseDir.resolve(translationEntry.getName().split("/")[1]);
                    InputStream inputStream = Objects.requireNonNull(AbstractNecrifyPlugin.class.getResourceAsStream("/" + translationEntry.getName()));
                    if (Files.exists(path, new LinkOption[0])) {
                        Properties existingBundle = new Properties();
                        existingBundle.load(Files.newInputStream(path, new OpenOption[0]));
                        PropertyResourceBundle jarBundle = new PropertyResourceBundle(inputStream);
                        Enumeration<String> jarBundleKeys = jarBundle.getKeys();
                        int changes = 0;
                        while (jarBundleKeys.hasMoreElements()) {
                            String key = jarBundleKeys.nextElement();
                            if (existingBundle.containsKey(key)) continue;
                            existingBundle.put(key, jarBundle.getString(key));
                            ++changes;
                        }
                        if (changes <= 0) continue;
                        LOGGER.info("updating {} entries in translation file {}", (Object)changes, (Object)translationEntry.getName());
                        existingBundle.store(Files.newOutputStream(path, new OpenOption[0]), null);
                        continue;
                    }
                    LOGGER.info("copying translation file {}", (Object)translationEntry.getName());
                    Files.copy(inputStream, path, new CopyOption[0]);
                    registeredPaths.add(path);
                }
            }
            ResourceBundleMessageProvider.registerFrom(paths, registry);
            try (Stream<Path> registeredStream = registeredPaths.stream();){
                ResourceBundleMessageProvider.registerFrom(registeredStream, registry);
            }
            GlobalTranslator.translator().addSource((Translator)registry);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while loading translations", (Throwable)e);
        }
    }
}

