/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.plugin;

import de.jvstvshd.necrify.lib.jackson.annotation.JsonIgnore;
import de.jvstvshd.necrify.lib.jackson.annotation.JsonProperty;
import de.jvstvshd.necrify.lib.jackson.databind.DeserializationFeature;
import de.jvstvshd.necrify.lib.jackson.databind.ObjectMapper;
import de.jvstvshd.necrify.lib.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

public class MuteData {
    public static final String MUTE_DATA_CHANNEL_IDENTIFIER = "necrify:mutedata";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int ADD = 0;
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int REMOVE = 1;
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int UPDATE = 2;
    public static final int PROTOCOL_VERSION = 1;
    public static final int RESET = 3;
    public static final int RECALCULATION = 4;
    public static final int UNKNOWN = -1;
    private final UUID uuid;
    private final String reason;
    private final LocalDateTime expiration;
    private final int type;
    private final UUID punishmentId;
    private final int version;

    public MuteData(@JsonProperty(value="type") int type, @JsonProperty(value="uuid") UUID uuid, @JsonProperty(value="reason") String reason, @JsonProperty(value="expiration") LocalDateTime expiration, @JsonProperty(value="punishment_id") UUID punishmentId, @JsonProperty(value="version") int version) {
        this.uuid = uuid;
        this.reason = reason;
        this.expiration = expiration;
        this.type = type;
        this.punishmentId = punishmentId;
        this.version = version;
    }

    public MuteData(UUID uuid, String reason, LocalDateTime expiration, int type, UUID punishmentId) {
        this.uuid = uuid;
        this.reason = reason;
        this.expiration = expiration;
        this.type = type;
        this.punishmentId = punishmentId;
        this.version = 1;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getReason() {
        return this.reason;
    }

    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    @Deprecated
    @JsonIgnore
    public boolean isAdd() {
        return this.type == 0;
    }

    @Deprecated
    @JsonIgnore
    public boolean isRemove() {
        return this.type == 1;
    }

    @Deprecated
    @JsonIgnore
    public boolean isUpdate() {
        return this.type == 2;
    }

    public UUID getPunishmentId() {
        return this.punishmentId;
    }
}

