/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.event.EventDispatcher;
import de.jvstvshd.necrify.api.event.punishment.PunishmentCancelledEvent;
import de.jvstvshd.necrify.api.event.punishment.PunishmentPersecutedEvent;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogAction;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.log.NecrifyPunishmentLog;
import de.jvstvshd.necrify.common.util.Util;
import java.time.LocalDateTime;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPunishment
implements Punishment {
    private final Component reason;
    private final ExecutorService executor;
    private final NecrifyUser user;
    private final UUID punishmentUuid;
    private final MessageProvider messageProvider;
    private final EventDispatcher eventDispatcher;
    private final AbstractNecrifyPlugin plugin;
    private LocalDateTime creationTime;
    private Punishment successor;
    private PunishmentLog cachedLog;
    @Language(value="sql")
    protected static final String APPLY_PUNISHMENT = "INSERT INTO necrify_punishment (uuid, type, expiration, reason, punishment_id, issued_at) VALUES (?, ?, ?, ?, ?, ?)";
    @Language(value="sql")
    protected static final String APPLY_CANCELLATION = "DELETE FROM necrify_punishment WHERE punishment_id = ?";
    @Language(value="sql")
    protected static final String APPLY_CHANGE = "UPDATE necrify_punishment SET reason = ?, expiration = ?, issued_at = ? WHERE punishment_id = ?";
    @Language(value="sql")
    protected static final String APPLY_SUCCESSOR = "UPDATE necrify_punishment SET successor = ? WHERE punishment_id = ?";
    @Language(value="sql")
    protected static final String APPLY_TIMESTAMP_UPDATE = "UPDATE necrify_punishment SET expiration = ?, issued_at = ? WHERE punishment_id = ?";
    private final boolean validity;

    public AbstractPunishment(@NotNull NecrifyUser user, @NotNull Component reason, @NotNull UUID punishmentUuid, @NotNull AbstractNecrifyPlugin plugin, @Nullable Punishment successor, @Nullable LocalDateTime issuedAt) {
        this.reason = Objects.requireNonNull(reason, "punishment must be reasoned");
        this.executor = plugin.getExecutor();
        this.user = Objects.requireNonNull(user, "punishment must be bound to a user");
        this.punishmentUuid = Objects.requireNonNull(punishmentUuid, "punishment must have a uuid");
        this.successor = successor;
        this.validity = true;
        this.messageProvider = plugin.getMessageProvider();
        this.eventDispatcher = plugin.getEventDispatcher();
        this.plugin = plugin;
        this.creationTime = issuedAt;
    }

    @Override
    @NotNull
    public Component getReason() {
        return this.reason;
    }

    @Override
    @NotNull
    public Component getRawReason() {
        return this.reason;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    protected <T> CompletableFuture<T> executeAsync(Callable<T> task, ExecutorService executorService) {
        CompletableFuture future = new CompletableFuture();
        executorService.execute(() -> {
            try {
                future.complete(task.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public NecrifyUser getUser() {
        return this.user;
    }

    @Override
    @NotNull
    public UUID getPunishmentUuid() {
        return this.punishmentUuid;
    }

    protected String convertReason(Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    public boolean isValid() {
        return this.validity;
    }

    @Override
    public final CompletableFuture<Punishment> punish() {
        this.creationTime = LocalDateTime.now();
        return this.applyPunishment().whenCompleteAsync((punishment, throwable) -> {
            if (punishment != null) {
                this.getEventDispatcher().dispatch(new PunishmentPersecutedEvent((Punishment)punishment));
                this.log(PunishmentLogAction.CREATED, "Punishment has been created.");
            }
            this.disposeCachedLog();
        });
    }

    @Override
    public final CompletableFuture<Punishment> cancel() {
        return this.applyCancellation().whenCompleteAsync((punishment, throwable) -> {
            if (throwable != null) {
                this.plugin.getLogger().error("could not cancel punishment", throwable);
            }
            if (punishment != null) {
                this.getEventDispatcher().dispatch(new PunishmentCancelledEvent((Punishment)punishment));
                this.log(PunishmentLogAction.REMOVED, null);
            }
        });
    }

    protected abstract CompletableFuture<Punishment> applyPunishment();

    protected CompletableFuture<Punishment> applyCancellation() {
        throw new UnsupportedOperationException("cancellation is not supported for this punishment");
    }

    public String toString() {
        return "AbstractPunishment{reason=" + String.valueOf(this.reason) + ", service=" + String.valueOf(this.executor) + ", userUuid=" + String.valueOf(this.user.getUuid()) + ", userName=" + this.user.getUsername() + ", punishmentUuid=" + String.valueOf(this.punishmentUuid) + ", messageProvider=" + String.valueOf(this.messageProvider) + ", validity=" + this.validity + "} " + super.toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Punishment)) {
            return false;
        }
        Punishment that = (Punishment)o;
        return this.punishmentUuid.equals(that.getPunishmentUuid());
    }

    public int hashCode() {
        return this.punishmentUuid.hashCode();
    }

    protected void checkValidity() {
        if (!this.isValid()) {
            throw new IllegalStateException("punishment is invalid");
        }
    }

    @NotNull
    public MessageProvider getMessageProvider() {
        return this.messageProvider;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.punishmentUuid;
    }

    @NotNull
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @NotNull
    public AbstractNecrifyPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasSuccessor() {
        return this.successor != null;
    }

    @Override
    @NotNull
    public Punishment getSuccessor() {
        if (!this.hasSuccessor()) {
            throw new NoSuchElementException("this punishment has no successor");
        }
        return this.successor;
    }

    @Override
    @NotNull
    public LocalDateTime getCreationTime() {
        if (this.creationTime == null) {
            throw new IllegalStateException("punishment has not been created yet");
        }
        return this.creationTime;
    }

    @Override
    @Nullable
    public Punishment getPredecessor() {
        return this.user.getPunishments(new PunishmentType[0]).stream().filter(punishment -> punishment.hasSuccessor() && punishment.getSuccessor().equals(this)).findFirst().orElse(null);
    }

    @Override
    public boolean hasBeenCreated() {
        return this.creationTime != null;
    }

    void setSuccessor0(Punishment successor) {
        this.successor = successor;
    }

    @Override
    @NotNull
    public CompletableFuture<PunishmentLog> loadPunishmentLog() {
        if (this.cachedLog != null) {
            return CompletableFuture.completedFuture(this.cachedLog);
        }
        return Util.executeAsync(() -> {
            NecrifyPunishmentLog log = new NecrifyPunishmentLog(this.plugin, this);
            log.load(false);
            this.cachedLog = log;
            return log;
        }, this.executor);
    }

    public void disposeCachedLog() {
        if (this.plugin.getConfig().getConfiguration().getDataBaseData().getSqlType().startsWith("postgres")) {
            return;
        }
        this.cachedLog = null;
    }

    @Override
    @NotNull
    public PunishmentLogEntry createCurrentLogEntry() {
        return new PunishmentLogEntry(this.plugin.getSystemUser(), "Current state", PunishmentDuration.ofPunishment(this), this.getReason(), this.getPredecessor(), this, this.getSuccessorOrNull(), this.getCreationTime(), PunishmentLogAction.CREATED, this.cachedLog, LocalDateTime.now(), -1);
    }

    @Override
    @NotNull
    public Optional<NecrifyTemplateStage> getTemplateStage() {
        return Optional.empty();
    }

    public PunishmentLog getCachedLog() {
        return this.cachedLog;
    }

    public void log(PunishmentLogAction action, String message) {
        this.loadPunishmentLog().thenAccept(log -> log.log(action, message, this.plugin.getSystemUser()));
    }
}

