/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.PunishmentException;
import de.jvstvshd.necrify.api.duration.AbsolutePunishmentDuration;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.event.punishment.PunishmentChangedEvent;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.io.Adapters;
import de.jvstvshd.necrify.common.punishment.AbstractPunishment;
import de.jvstvshd.necrify.common.punishment.PunishmentBuilder;
import de.jvstvshd.necrify.common.util.Util;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTemporalPunishment
extends AbstractPunishment
implements TemporalPunishment {
    private final PunishmentDuration duration;

    public AbstractTemporalPunishment(NecrifyUser user, Component reason, UUID punishmentUuid, PunishmentDuration duration, AbstractNecrifyPlugin plugin, Punishment successor, LocalDateTime issuedAt) {
        super(user, reason, punishmentUuid, plugin, successor, issuedAt);
        this.duration = Objects.requireNonNull(duration, "temporal punishment must have a duration");
    }

    @Override
    @NotNull
    public PunishmentDuration getDuration() {
        return this.duration;
    }

    @Override
    public boolean isOngoing() {
        return this.getDuration().expiration().isAfter(LocalDateTime.now());
    }

    @Override
    public String toString() {
        return "AbstractTemporalPunishment{duration=" + String.valueOf(this.duration) + "} " + super.toString();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isOngoing();
    }

    @Override
    protected void checkValidity() {
        if (!this.isValid()) {
            throw new IllegalStateException("punishment is invalid (probably isOngoing returned false)");
        }
    }

    @Override
    @NotNull
    public Component getReason() {
        return super.getReason().replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("<UNTIL>").replacement((ComponentLike)Component.text((String)this.getDuration().remainingDuration(), (TextColor)NamedTextColor.YELLOW)).build());
    }

    @Override
    @NotNull
    public final CompletableFuture<Punishment> change(@NotNull PunishmentDuration newDuration, @Nullable LocalDateTime creationTime, Component newReason) throws PunishmentException {
        if (!this.getType().isBan() && !this.getType().isMute()) {
            throw new IllegalStateException("only bans and mutes can be changed");
        }
        PunishmentDuration oldDuration = this.getDuration();
        Component oldReason = this.getReason();
        return this.executeAsync(() -> {
            AbstractTemporalPunishment punishment;
            LocalDateTime newCreatedAt = creationTime == null ? this.getCreationTime() : creationTime;
            Component newRsn = newReason == null ? this.getReason() : newReason;
            Query.query((String)"UPDATE necrify_punishment SET reason = ?, expiration = ?, issued_at = ? WHERE punishment_id = ?", (Object[])new Object[0]).single(Call.of().bind(this.convertReason(newRsn)).bind(newDuration.expirationAsTimestamp()).bind(Timestamp.valueOf(newCreatedAt)).bind((Object)this.getPunishmentUuid(), Adapters.UUID_ADAPTER)).update();
            if (this.hasSuccessor()) {
                this.updateSuccessor().join();
            }
            PunishmentBuilder builder = new PunishmentBuilder(this.getPlugin()).withUser(this.getUser()).withReason(newReason).withDuration(newDuration).withCreationTime(newCreatedAt).withPunishmentUuid(this.getPunishmentUuid()).withSuccessor(this.getSuccessorOrNull());
            if (this.getType().isBan()) {
                punishment = builder.buildBan();
            } else if (this.getType().isMute()) {
                punishment = builder.buildMute();
            } else {
                throw new IllegalStateException("punishment type is not a ban or mute");
            }
            this.getPlugin().getEventDispatcher().dispatch(new PunishmentChangedEvent(punishment, (Punishment)this));
            return punishment;
        }, this.getExecutor());
    }

    @Override
    protected CompletableFuture<Punishment> applyCancellation() throws PunishmentException {
        return this.executeAsync(() -> {
            Punishment predecessor;
            if (this.hasSuccessor()) {
                this.updateSuccessor().join();
            }
            if ((predecessor = this.getPredecessor()) != null) {
                if (this.hasSuccessor()) {
                    predecessor.setSuccessor(this.getSuccessor()).join();
                } else {
                    predecessor.setSuccessor(null);
                }
            }
            Query.query((String)"DELETE FROM necrify_punishment WHERE punishment_id = ?", (Object[])new Object[0]).single(Call.of().bind((Object)this.getPunishmentUuid(), Adapters.UUID_ADAPTER)).delete();
            return this;
        }, this.getExecutor());
    }

    private CompletableFuture<Punishment> updateSuccessor() {
        Punishment successor = this.getSuccessor();
        if (successor instanceof TemporalPunishment) {
            TemporalPunishment temporalSuccessor = (TemporalPunishment)successor;
            PunishmentDuration total = temporalSuccessor.totalDuration();
            LocalDateTime newExpiration = LocalDateTime.now().plus(total.javaDuration());
            temporalSuccessor.change(PunishmentDuration.from(newExpiration), LocalDateTime.now(), successor.getReason()).join();
        }
        return CompletableFuture.completedFuture(successor);
    }

    @Override
    @NotNull
    public abstract StandardPunishmentType getType();

    @Override
    protected CompletableFuture<Punishment> applyPunishment() throws PunishmentException {
        this.checkValidity();
        AbsolutePunishmentDuration duration = this.getDuration().absolute();
        return this.executeAsync(() -> {
            Query.query((String)"INSERT INTO necrify_punishment (uuid, type, expiration, reason, punishment_id, issued_at) VALUES (?, ?, ?, ?, ?, ?)", (Object[])new Object[0]).single(Call.of().bind((Object)this.getUser().getUuid(), Adapters.UUID_ADAPTER).bind(Integer.valueOf(this.getType().getId())).bind(duration.expirationAsTimestamp()).bind(this.convertReason(this.getRawReason())).bind((Object)this.getPunishmentUuid(), Adapters.UUID_ADAPTER).bind(Timestamp.valueOf(this.getCreationTime()))).insert();
            return this;
        }, this.getExecutor());
    }

    @Override
    @NotNull
    public CompletableFuture<Punishment> setSuccessor(Punishment successor) {
        if (successor == null) {
            return Util.executeAsync(() -> {
                Query.query((String)"UPDATE necrify_punishment SET successor = ? WHERE punishment_id = ?", (Object[])new Object[0]).single(Call.of().bind(null, Adapters.UUID_NULL_ADAPTER).bind((Object)this.getPunishmentUuid(), Adapters.UUID_ADAPTER)).update();
                return this;
            }, this.getExecutor());
        }
        if (!this.getType().getRelatedTypes().contains(successor.getType())) {
            throw new IllegalArgumentException("successor punishment is not related to this punishment");
        }
        if (!this.getUser().equals(successor.getUser())) {
            throw new IllegalArgumentException("successor punishment is not for the same user");
        }
        if (Util.circularSuccessionChain(this, successor)) {
            throw new IllegalStateException("circular successor chain detected");
        }
        return Util.executeAsync(() -> {
            LocalDateTime successorNewExpiration;
            Query.query((String)"UPDATE necrify_punishment SET successor = ? WHERE punishment_id = ?", (Object[])new Object[0]).single(Call.of().bind((Object)successor.getPunishmentUuid(), Adapters.UUID_ADAPTER).bind((Object)this.getPunishmentUuid(), Adapters.UUID_ADAPTER)).update();
            if (successor instanceof TemporalPunishment) {
                TemporalPunishment temporalSuccessor = (TemporalPunishment)successor;
                PunishmentDuration total = temporalSuccessor.totalDuration();
                successorNewExpiration = this.duration.expiration().plus(total.javaDuration());
            } else {
                successorNewExpiration = PunishmentDuration.PERMANENT.expiration();
            }
            LocalDateTime issuanceSuccessor = this.duration.expiration();
            if (successor instanceof TemporalPunishment) {
                TemporalPunishment temporalSuccessor = (TemporalPunishment)successor;
                Punishment newSuccessor = temporalSuccessor.change(PunishmentDuration.from(successorNewExpiration), issuanceSuccessor, successor.getReason()).join();
                this.setSuccessor0(newSuccessor);
            } else {
                Query.query((String)"UPDATE necrify_punishment SET expiration = ?, issued_at = ? WHERE punishment_id = ?", (Object[])new Object[0]).single(Call.of().bind(Timestamp.valueOf(successorNewExpiration)).bind(issuanceSuccessor).bind((Object)successor.getPunishmentUuid(), Adapters.UUID_ADAPTER)).update();
                this.setSuccessor0(successor);
            }
            return this;
        }, this.getExecutor());
    }

    @Override
    @NotNull
    public PunishmentDuration totalDuration() {
        return PunishmentDuration.fromDuration(Duration.between(this.getCreationTime(), this.getDuration().expiration()));
    }
}

