/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import de.jvstvshd.necrify.api.punishment.util.ReasonHolder;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.AbstractTemporalPunishment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedPunishment
extends AbstractTemporalPunishment {
    private final List<TemporalPunishment> bans;

    private ChainedPunishment(List<TemporalPunishment> bans, AbstractNecrifyPlugin plugin) {
        this(bans.getFirst(), bans, plugin);
    }

    private ChainedPunishment(TemporalPunishment tp, List<TemporalPunishment> bans, AbstractNecrifyPlugin plugin) {
        super(tp.getUser(), tp.getReason(), tp.getPunishmentUuid(), tp.getDuration(), plugin, tp.getSuccessorOrNull(), tp.getCreationTime());
        this.bans = bans;
    }

    @Override
    @NotNull
    public Component getReason() {
        return this.bans.stream().map(ReasonHolder::getReason).reduce((Component)Component.empty(), (a, b) -> a.append((Component)Component.newline()).append(b));
    }

    public static ChainedPunishment of(TemporalPunishment last, AbstractNecrifyPlugin plugin) {
        ArrayList<TemporalPunishment> bans = new ArrayList<TemporalPunishment>();
        TemporalPunishment current = last;
        while (current.getPredecessor() != null) {
            bans.add(current);
            current = (TemporalPunishment)current.getPredecessor();
        }
        bans.add(current);
        return new ChainedPunishment(bans, plugin);
    }

    @Override
    @NotNull
    public StandardPunishmentType getType() {
        return this.bans.getFirst().getType().standard();
    }

    @Override
    public boolean isPermanent() {
        return this.bans.stream().anyMatch(TemporalPunishment::isPermanent);
    }

    @Override
    @NotNull
    public Component createFullReason(@Nullable Locale locale) {
        return ((TemporalPunishment)this.bans.stream().max((a, b) -> b.getDuration().expiration().compareTo(a.getDuration().expiration())).get()).createFullReason(locale);
    }
}

