/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.PunishmentException;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.util.EmptyPunishmentType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HistoricalPunishment
implements TemporalPunishment {
    private final UUID punishmentUuid;
    private NecrifyUser user;
    private LocalDateTime creationTime;
    private final PunishmentLog log;
    private LocalDateTime expirationTime;

    public HistoricalPunishment(UUID punishmentUuid, @Nullable NecrifyUser user, LocalDateTime creationTime, LocalDateTime expirationTime, PunishmentLog log) {
        this.punishmentUuid = punishmentUuid;
        this.user = user;
        this.creationTime = creationTime;
        this.log = log;
        this.expirationTime = expirationTime;
    }

    @Override
    public boolean isOngoing() {
        return false;
    }

    @Override
    public CompletableFuture<Punishment> punish() {
        return (CompletableFuture)this.throwException();
    }

    @Override
    public CompletableFuture<Punishment> cancel() {
        return (CompletableFuture)this.throwException();
    }

    @Override
    public CompletableFuture<Punishment> change(@Nullable Component newReason) {
        return (CompletableFuture)this.throwException();
    }

    @Override
    @NotNull
    public PunishmentType getType() {
        return EmptyPunishmentType.INSTANCE;
    }

    @Override
    @NotNull
    public UUID getPunishmentUuid() {
        return this.punishmentUuid;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.getPunishmentUuid();
    }

    @Override
    @NotNull
    public NecrifyUser getUser() {
        return this.user;
    }

    @Override
    public boolean hasSuccessor() {
        return false;
    }

    @Override
    @NotNull
    public Punishment getSuccessor() {
        return (Punishment)this.throwException();
    }

    @Override
    @NotNull
    public CompletableFuture<Punishment> setSuccessor(Punishment successor) {
        return (CompletableFuture)this.throwException();
    }

    @Override
    @NotNull
    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public boolean hasBeenCreated() {
        return true;
    }

    @Override
    @Nullable
    public Punishment getPredecessor() {
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<PunishmentLog> loadPunishmentLog() {
        return CompletableFuture.completedFuture(this.log);
    }

    @Override
    @NotNull
    public PunishmentLogEntry createCurrentLogEntry() {
        return (PunishmentLogEntry)this.throwException();
    }

    @Override
    @NotNull
    public Component getReason() {
        return this.log.getLatestEntry().reason();
    }

    @Override
    @NotNull
    public Component getRawReason() {
        return this.getReason();
    }

    @Override
    @NotNull
    public Component createFullReason(@Nullable Locale locale) {
        return this.getRawReason();
    }

    @Override
    @NotNull
    public PunishmentDuration getDuration() {
        return PunishmentDuration.fromDuration(Duration.between(this.creationTime, this.expirationTime));
    }

    @Override
    public boolean isPermanent() {
        return this.getDuration().isPermanent();
    }

    @Override
    @NotNull
    public CompletableFuture<Punishment> change(@NotNull PunishmentDuration newDuration, @Nullable LocalDateTime creationTime, @Nullable Component newReason) throws PunishmentException {
        return (CompletableFuture)this.throwException();
    }

    @Override
    @NotNull
    public PunishmentDuration totalDuration() {
        return this.getDuration();
    }

    @Override
    @NotNull
    public Optional<NecrifyTemplateStage> getTemplateStage() {
        return Optional.empty();
    }

    private <T> T throwException() {
        throw new UnsupportedOperationException("This method is not supported on this object. This punishment was deleted and this instance only serves as a reference to the punishment that was deleted.");
    }

    public HistoricalPunishment setUser(NecrifyUser user) {
        this.user = user;
        return this;
    }

    public HistoricalPunishment setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public HistoricalPunishment setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }
}

