/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.PunishmentException;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Ban;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.AbstractTemporalPunishment;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NecrifyBan
extends AbstractTemporalPunishment
implements Ban {
    public NecrifyBan(NecrifyUser user, Component reason, UUID punishmentUuid, PunishmentDuration duration, AbstractNecrifyPlugin plugin, Punishment successor, LocalDateTime issuedAt) {
        super(user, reason, punishmentUuid, duration, plugin, successor, issuedAt);
    }

    @Override
    public CompletableFuture<Punishment> applyPunishment() throws PunishmentException {
        return super.applyPunishment().whenComplete((p, throwable) -> this.tryKick());
    }

    private void tryKick() {
        this.getUser().kick(this.createFullReason(null));
    }

    @Override
    @NotNull
    public Component createFullReason(@Nullable Locale locale) {
        if (!this.isValid()) {
            return ((TextComponent)Component.text((String)"INVALID").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.DARK_RED);
        }
        if (this.isPermanent()) {
            return this.getMessageProvider().provide("punishment.ban.permanent.full-reason", this.getReason());
        }
        TextComponent until = (TextComponent)Component.text((String)this.getDuration().expiration().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).color((TextColor)NamedTextColor.YELLOW);
        return this.getMessageProvider().provide("punishment.ban.temp.full-reason", new Component[]{Component.text((String)this.getDuration().remainingDuration()).color((TextColor)NamedTextColor.YELLOW), this.getReason(), until}).color((TextColor)NamedTextColor.GRAY);
    }

    @Override
    public boolean isPermanent() {
        return this.getDuration().isPermanent();
    }

    @Override
    @NotNull
    public StandardPunishmentType getType() {
        return this.getDuration().isPermanent() ? StandardPunishmentType.PERMANENT_BAN : StandardPunishmentType.TEMPORARY_BAN;
    }
}

