/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Mute;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.AbstractTemporalPunishment;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;

public class NecrifyMute
extends AbstractTemporalPunishment
implements Mute {
    public NecrifyMute(NecrifyUser user, Component reason, UUID punishmentUuid, PunishmentDuration duration, AbstractNecrifyPlugin plugin, Punishment successor, LocalDateTime creationTime) {
        super(user, reason, punishmentUuid, duration, plugin, successor, creationTime);
    }

    @Override
    @NotNull
    public StandardPunishmentType getType() {
        return this.isPermanent() ? StandardPunishmentType.PERMANENT_MUTE : StandardPunishmentType.TEMPORARY_MUTE;
    }

    @Override
    public boolean isPermanent() {
        return this.getDuration().isPermanent();
    }

    @Override
    @NotNull
    public Component createFullReason(Locale source) {
        if (!this.isValid()) {
            return ((TextComponent)Component.text((String)"INVALID").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.DARK_RED);
        }
        if (this.isPermanent()) {
            return this.getMessageProvider().provide("punishment.mute.permanent.full-reason", this.getReason());
        }
        TextComponent until = (TextComponent)Component.text((String)this.getDuration().expiration().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).color((TextColor)NamedTextColor.YELLOW);
        return this.getMessageProvider().provide("punishment.mute.temp.full-reason", new Component[]{Component.text((String)this.getDuration().remainingDuration()).color((TextColor)NamedTextColor.YELLOW), this.getReason(), until}).color((TextColor)NamedTextColor.GRAY);
    }
}

