/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentFactory;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.PunishmentBuilder;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class NecrifyPunishmentFactory
implements PunishmentFactory {
    private final AbstractNecrifyPlugin plugin;

    public NecrifyPunishmentFactory(AbstractNecrifyPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Punishment createPunishment(@NotNull PunishmentType type, @NotNull Map<String, Object> data) {
        PunishmentDuration duration = (PunishmentDuration)data.get("duration");
        Component reason = (Component)data.get("reason");
        UUID punishmentUuid = (UUID)data.get("punishmentUuid");
        NecrifyUser user = (NecrifyUser)data.get("user");
        Punishment successor = (Punishment)data.get("successor");
        LocalDateTime creationTime = (LocalDateTime)data.get("issued_at");
        PunishmentBuilder builder = PunishmentBuilder.newBuilder(this.plugin).withDuration(duration).withReason(reason).withUser(user).withPunishmentUuid(punishmentUuid).withSuccessor(successor).withCreationTime(creationTime);
        return switch (type.standard()) {
            case StandardPunishmentType.TEMPORARY_BAN, StandardPunishmentType.PERMANENT_BAN -> builder.buildBan();
            case StandardPunishmentType.TEMPORARY_MUTE, StandardPunishmentType.PERMANENT_MUTE -> builder.buildMute();
            case StandardPunishmentType.KICK -> builder.buildKick();
            default -> throw new UnsupportedOperationException("unhandled punishment type: " + type.getName());
        };
    }
}

