/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.punishment.NecrifyBan;
import de.jvstvshd.necrify.common.punishment.NecrifyKick;
import de.jvstvshd.necrify.common.punishment.NecrifyMute;
import java.time.LocalDateTime;
import java.util.UUID;
import net.kyori.adventure.text.Component;

public class PunishmentBuilder {
    private final AbstractNecrifyPlugin plugin;
    private NecrifyUser user;
    private Component reason;
    private PunishmentDuration duration;
    private UUID punishmentUuid;
    private Punishment successor;
    private LocalDateTime creationTime;

    public PunishmentBuilder(AbstractNecrifyPlugin plugin) {
        this.plugin = plugin;
    }

    public static PunishmentBuilder newBuilder(AbstractNecrifyPlugin plugin) {
        return new PunishmentBuilder(plugin);
    }

    public NecrifyUser user() {
        return this.user;
    }

    public PunishmentBuilder withUser(NecrifyUser user) {
        this.user = user;
        return this;
    }

    public Component reason() {
        return this.reason;
    }

    public PunishmentBuilder withReason(Component reason) {
        this.reason = reason;
        return this;
    }

    public PunishmentDuration duration() {
        return this.duration;
    }

    public PunishmentBuilder withDuration(PunishmentDuration duration) {
        this.duration = duration;
        return this;
    }

    public UUID punishmentUuid() {
        return this.punishmentUuid;
    }

    public PunishmentBuilder withPunishmentUuid(UUID punishmentUuid) {
        this.punishmentUuid = punishmentUuid;
        return this;
    }

    public Punishment successor() {
        return this.successor;
    }

    public PunishmentBuilder withSuccessor(Punishment successor) {
        this.successor = successor;
        return this;
    }

    public LocalDateTime creationTime() {
        return this.creationTime;
    }

    public PunishmentBuilder withCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public NecrifyBan buildBan() {
        this.validateValues();
        return new NecrifyBan(this.user, this.reason, this.punishmentUuid, this.duration.absolute(), this.plugin, this.successor, this.creationTime);
    }

    public NecrifyKick buildKick() {
        this.validateValues();
        return this.plugin.createKick(this.reason, this.user, this.punishmentUuid);
    }

    public NecrifyMute buildMute() {
        this.validateValues();
        return new NecrifyMute(this.user, this.reason, this.punishmentUuid, this.duration.absolute(), this.plugin, this.successor, this.creationTime);
    }

    private void validateValues() {
        if (this.punishmentUuid == null) {
            this.punishmentUuid = UUID.randomUUID();
        }
        if (this.user == null) {
            throw new NullPointerException("user is null");
        }
        if (this.reason == null) {
            throw new NullPointerException("reason is null");
        }
    }
}

