/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.punishment.log;

import de.chojo.sadu.mapper.wrapper.Row;
import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.event.punishment.PunishmentLogEvent;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogAction;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogActionRegistry;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserManager;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.io.Adapters;
import de.jvstvshd.necrify.common.punishment.HistoricalPunishment;
import de.jvstvshd.necrify.common.util.Util;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NecrifyPunishmentLog
implements PunishmentLog {
    private Punishment punishment;
    private final List<PunishmentLogEntry> entries = Collections.synchronizedList(new ArrayList());
    private final AbstractNecrifyPlugin plugin;
    private final UserManager userManager;
    private final Logger logger;
    private final UUID uuid;

    public NecrifyPunishmentLog(AbstractNecrifyPlugin plugin, UUID uuid) {
        this.plugin = plugin;
        this.userManager = plugin.getUserManager();
        this.logger = plugin.getLogger();
        this.uuid = uuid;
        Objects.requireNonNull(uuid, "uuid must not be null.");
    }

    public NecrifyPunishmentLog(AbstractNecrifyPlugin plugin, Punishment punishment) {
        this.logger = plugin.getLogger();
        this.userManager = plugin.getUserManager();
        this.plugin = plugin;
        this.punishment = punishment;
        this.uuid = punishment.getUuid();
        Objects.requireNonNull(this.uuid, "uuid must not be null.");
    }

    public synchronized boolean load(boolean loadIfAlreadyLoaded) {
        if (!loadIfAlreadyLoaded && !this.entries.isEmpty()) {
            return false;
        }
        if (this.punishment == null) {
            this.punishment = new HistoricalPunishment(this.uuid, null, null, null, this);
        }
        this.plugin.getHistoricalPunishmentCache().put((Object)this.uuid, (Object)this.punishment);
        AtomicInteger index = new AtomicInteger();
        List entries = Query.query((String)"SELECT id, actor_id, message, expiration, reason, predecessor, successor, action, begins_at, created_at FROM punishment_log WHERE punishment_id = ? ORDER BY id ASC", (Object[])new Object[0]).single(Call.of().bind((Object)this.uuid, Adapters.UUID_ADAPTER)).map(row -> NecrifyPunishmentLog.fromRow(row, this.plugin, this, this.punishment, index.getAndIncrement())).all();
        if (entries.isEmpty()) {
            this.plugin.getHistoricalPunishmentCache().invalidate((Object)this.uuid);
            return false;
        }
        Collections.sort(entries);
        this.entries.clear();
        this.entries.addAll(entries);
        Punishment punishment = this.punishment;
        if (punishment instanceof HistoricalPunishment) {
            HistoricalPunishment historicalPunishment = (HistoricalPunishment)punishment;
            historicalPunishment.setCreationTime(this.getLatestEntry().beginsAt()).setExpirationTime(this.getLatestEntry().duration().expiration()).setUser(this.getEntry(PunishmentLogAction.INFORMATION).actor());
        }
        return true;
    }

    public static PunishmentLogEntry fromRow(Row row, AbstractNecrifyPlugin plugin, PunishmentLog log, Punishment punishment, int index) throws SQLException {
        int id = row.getInt(1);
        UUID actorUuid = Util.getUuid(row, 2);
        NecrifyUser actor = actorUuid == null ? null : plugin.getUserManager().loadUser(actorUuid).join().orElseThrow(() -> new IllegalStateException("Actor not found " + String.valueOf(actorUuid)));
        String message = row.getString(3);
        PunishmentDuration duration = PunishmentDuration.fromTimestamp(row.getTimestamp(4));
        Component reason = MiniMessage.miniMessage().deserialize((Object)row.getString(5));
        Punishment predecessor = NecrifyPunishmentLog.getPunishment(Util.getUuid(row, 6), plugin);
        Punishment successor = NecrifyPunishmentLog.getPunishment(Util.getUuid(row, 7), plugin);
        PunishmentLogAction action = PunishmentLogActionRegistry.getAction(row.getString(8)).orElse(PunishmentLogAction.UNKNOWN);
        LocalDateTime beginsAt = row.getTimestamp(9).toLocalDateTime();
        LocalDateTime instant = row.getTimestamp(10).toLocalDateTime();
        return new PunishmentLogEntry(actor, message, duration, reason, predecessor, punishment, successor, beginsAt, action, log, instant, index);
    }

    @Nullable
    private static Punishment getPunishment(@Nullable UUID uuid, AbstractNecrifyPlugin plugin) {
        return uuid == null ? null : (Punishment)plugin.getPunishment(uuid).join().orElse(null);
    }

    @Override
    @NotNull
    public Punishment getPunishment() {
        return this.punishment;
    }

    @Override
    @NotNull
    public List<PunishmentLogEntry> getEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public List<PunishmentLogEntry> getEntries(@NotNull PunishmentLogAction action) {
        return this.entries.stream().filter(entry -> entry.action().equals(action)).toList();
    }

    @Override
    @Nullable
    public PunishmentLogEntry getEntry(@NotNull PunishmentLogAction action) {
        return this.getEntries(action).getFirst();
    }

    @Override
    @NotNull
    public PunishmentLogEntry getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public void log(@NotNull PunishmentLogAction action, @NotNull String message, @NotNull NecrifyUser actor) {
        if (this.punishment == null || this.punishment instanceof HistoricalPunishment) {
            throw new IllegalStateException("Punishment no longer exists. This method is only applicable to still-existing punishments.");
        }
        if (action.onlyOnce() && this.getEntry(action) != null) {
            throw new IllegalArgumentException("This action can only be logged once.");
        }
        PunishmentLogEntry entry = new PunishmentLogEntry(actor, message, PunishmentDuration.ofPunishment(this.punishment), this.punishment.getReason(), this.punishment.getPredecessor(), this.punishment, this.punishment.getSuccessor(), this.punishment.getCreationTime(), action, this, LocalDateTime.now(), this.entries.size());
        this.entries.add(entry);
        Util.executeAsync(() -> Query.query((String)"INSERT INTO necrify_schema.punishment_log (punishment_id, actor_id, message, expiration, reason, predecessor, successor, action, begins_at created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object[])new Object[0]).single(Call.of().bind((Object)this.punishment.getUuid(), Adapters.UUID_ADAPTER).bind((Object)actor.getUuid(), Adapters.UUID_ADAPTER).bind(message).bind(PunishmentDuration.ofPunishment(this.punishment).expirationAsTimestamp()).bind((String)MiniMessage.miniMessage().serialize(this.punishment.getReason())).bind(this.punishment.getPredecessor() == null ? null : this.punishment.getPredecessor().getUuid(), Adapters.UUID_ADAPTER).bind(this.punishment.getSuccessorOrNull() == null ? null : this.punishment.getSuccessor().getUuid(), Adapters.UUID_ADAPTER).bind(action.name()).bind(Timestamp.valueOf(entry.beginsAt())).bind(Timestamp.from(Instant.now()))).insert().changed(), this.plugin.getExecutor()).whenComplete((aBoolean, throwable) -> {
            if (throwable != null) {
                this.logger.error("Could not log punishment action.", throwable);
                return;
            }
            this.plugin.getEventDispatcher().dispatch(new PunishmentLogEvent(entry));
        });
    }

    public void addEntry(PunishmentLogEntry entry) {
        this.entries.add(entry);
    }
}

