/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.template;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.template.MinecraftTemplateManager;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

public class MinecraftTemplate
implements NecrifyTemplate {
    private final Set<NecrifyTemplateStage> stages = Collections.synchronizedSet(new TreeSet());
    private final String name;
    private final AbstractNecrifyPlugin plugin;
    private final MiniMessage miniMessage;

    public MinecraftTemplate(String name, AbstractNecrifyPlugin plugin, MiniMessage miniMessage) {
        this.name = name;
        this.plugin = plugin;
        this.miniMessage = miniMessage;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public Collection<NecrifyTemplateStage> stages() {
        return this.stages;
    }

    @Override
    @NotNull
    public NecrifyTemplateStage getStage(int index) {
        return this.stages().stream().skip(index).findFirst().orElseThrow();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> addStage(NecrifyTemplateStage stage) {
        return Util.executeAsync(() -> {
            Query.query((String)"INSERT INTO necrify_template_stage (template_id, index, duration, type, reason) VALUES ((SELECT id FROM necrify_template WHERE name = ?), ?, ?, ?, ?)", (Object[])new Object[0]).single(Call.of().bind(this.name).bind(Integer.valueOf(stage.index())).bind(Long.valueOf(stage.duration().javaDuration().toMillis())).bind(Integer.valueOf(stage.punishmentType().getId())).bind((String)this.miniMessage.serialize(stage.reason()))).insert().rows();
            this.addStage0(stage);
            return null;
        }, this.plugin.getExecutor());
    }

    public void addStage0(NecrifyTemplateStage stage) {
        this.stages.add(stage);
    }

    @Override
    public NecrifyTemplateStage removeStage(int index) {
        NecrifyTemplateStage stage = this.getStage(index);
        this.stages.remove(stage);
        this.stages.stream().filter(s -> s.index() > index).forEach(s -> s.changeIndex(s.index() - 1));
        return stage;
    }

    @Override
    public CompletableFuture<Integer> delete() {
        return Util.executeAsync(() -> {
            int rows = Query.query((String)"DELETE FROM necrify_template WHERE name = ?", (Object[])new Object[0]).single(Call.of().bind(this.name)).delete().rows();
            ((MinecraftTemplateManager)this.plugin.getTemplateManager()).removeTemplate(this.name);
            return rows;
        }, this.plugin.getExecutor());
    }
}

