/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.template;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.PunishmentTypeRegistry;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.TemplateManager;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.template.MinecraftTemplate;
import de.jvstvshd.necrify.common.template.MinecraftTemplateStage;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

public class MinecraftTemplateManager
implements TemplateManager {
    private final AbstractNecrifyPlugin plugin;
    private final Set<NecrifyTemplate> templates = Collections.synchronizedSet(new HashSet());
    private final MiniMessage miniMessage;

    public MinecraftTemplateManager(AbstractNecrifyPlugin plugin, MiniMessage miniMessage) {
        this.plugin = plugin;
        this.miniMessage = miniMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<Collection<? extends NecrifyTemplate>> loadTemplates() {
        return Util.executeAsync(() -> {
            HashMap loadedTemplates = new HashMap();
            Query.query((String)"SELECT name FROM necrify_punishment_template;", (Object[])new Object[0]).single(Call.of()).map(row -> new MinecraftTemplate(row.getString(1), this.plugin, this.miniMessage)).all().forEach(minecraftTemplate -> loadedTemplates.put(minecraftTemplate.name(), minecraftTemplate));
            Query.query((String)"SELECT t.name, s.index, s.duration, s.type, s.reason FROM necrify_punishment_template t, necrify_punishment_template_stage s WHERE t.id = s.template_id", (Object[])new Object[0]).single(Call.of()).map(row -> {
                String templateName = row.getString(1);
                MinecraftTemplate template = (MinecraftTemplate)loadedTemplates.get(templateName);
                MinecraftTemplateStage stage = new MinecraftTemplateStage(template, PunishmentTypeRegistry.getType(row.getInt(4)), PunishmentDuration.fromMillis(row.getLong(3)), this.miniMessage.deserialize((Object)row.getString(5)), row.getInt(2), this.plugin);
                template.addStage0(stage);
                return null;
            }).all();
            Collection values = loadedTemplates.values();
            this.templates.addAll(values);
            return values;
        }, this.plugin.getExecutor());
    }

    @Override
    @NotNull
    public Optional<NecrifyTemplate> getTemplate(String name) {
        return this.templates.stream().filter(t -> t.name().equals(name)).findFirst();
    }

    @Override
    @NotNull
    public CompletableFuture<NecrifyTemplate> createTemplate(String name) {
        if (this.templates.stream().anyMatch(t -> t.name().equals(name))) {
            throw new IllegalArgumentException("Template with name " + name + " already exists");
        }
        return Util.executeAsync(() -> {
            Query.query((String)"INSERT INTO necrify_punishment_template (name) VALUES (?)", (Object[])new Object[0]).single(Call.call().bind(name)).insert();
            MinecraftTemplate template = new MinecraftTemplate(name, this.plugin, this.miniMessage);
            this.templates.add(template);
            return template;
        }, this.plugin.getExecutor());
    }

    @Override
    @NotNull
    public Collection<? extends NecrifyTemplate> getTemplates() {
        return Collections.unmodifiableCollection(this.templates);
    }

    public void removeTemplate(String name) {
        this.templates.removeIf(t -> t.name().equals(name));
    }
}

