/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.template;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public final class MinecraftTemplateStage
implements NecrifyTemplateStage {
    private final NecrifyTemplate template;
    private final PunishmentType punishmentType;
    private final PunishmentDuration duration;
    private final Component reason;
    private int index;
    private final AbstractNecrifyPlugin plugin;

    public MinecraftTemplateStage(NecrifyTemplate template, PunishmentType punishmentType, PunishmentDuration duration, Component reason, int index, AbstractNecrifyPlugin plugin) {
        this.template = template;
        this.punishmentType = punishmentType;
        this.duration = duration;
        this.reason = reason;
        this.index = index;
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> changeDuration(PunishmentDuration duration) {
        return Util.executeAsync(() -> {
            Query.query((String)"UPDATE necrify_template_stage SET duration = ? WHERE template_id = (SELECT id FROM necrify_template WHERE name = ?) AND index = ?", (Object[])new Object[0]).single(Call.of().bind(Long.valueOf(duration.javaDuration().toMillis())).bind(this.template.name()).bind(Integer.valueOf(this.index))).update();
            return null;
        }, this.plugin.getExecutor());
    }

    @Override
    @NotNull
    public CompletableFuture<Void> delete() {
        return Util.executeAsync(() -> {
            Query.query((String)"DELETE FROM necrify_template_stage WHERE template_id = (SELECT id FROM necrify_template WHERE name = ?) AND index = ?", (Object[])new Object[0]).single(Call.of().bind(this.template.name()).bind(Integer.valueOf(this.index))).delete();
            this.template.removeStage(this.index);
            return null;
        }, this.plugin.getExecutor());
    }

    @Override
    @NotNull
    public PunishmentType punishmentType() {
        return this.punishmentType;
    }

    @Override
    public int compareTo(@NotNull NecrifyTemplateStage o) {
        return Integer.compare(this.index, o.index());
    }

    @Override
    @NotNull
    public NecrifyTemplateStage next() {
        return this.template.getStage(this.index + 1);
    }

    @Override
    @NotNull
    public NecrifyTemplateStage nextOrThis() {
        return this.index + 1 < this.template.stages().size() ? this.template.getStage(this.index + 1) : this;
    }

    @Override
    public void changeIndex(int index) {
        this.index = index;
    }

    @Override
    @NotNull
    public NecrifyTemplate template() {
        return this.template;
    }

    @Override
    @NotNull
    public PunishmentDuration duration() {
        return this.duration;
    }

    @Override
    @NotNull
    public Component reason() {
        return this.reason;
    }

    @Override
    public int index() {
        return this.index;
    }

    public AbstractNecrifyPlugin plugin() {
        return this.plugin;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MinecraftTemplateStage that = (MinecraftTemplateStage)obj;
        return Objects.equals(this.template, that.template) && Objects.equals(this.punishmentType, that.punishmentType) && Objects.equals(this.duration, that.duration) && Objects.equals(this.reason, that.reason) && this.index == that.index && Objects.equals(this.plugin, that.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.punishmentType, this.duration, this.reason, this.index, this.plugin);
    }

    public String toString() {
        return "MinecraftTemplateStage[template=" + String.valueOf(this.template) + ", punishmentType=" + String.valueOf(this.punishmentType) + ", duration=" + String.valueOf(this.duration) + ", reason=" + String.valueOf(this.reason) + ", index=" + this.index + ", plugin=" + String.valueOf(this.plugin) + "]";
    }
}

