/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.user;

import com.google.common.collect.ImmutableList;
import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.event.user.UserDeletedEvent;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Ban;
import de.jvstvshd.necrify.api.punishment.Kick;
import de.jvstvshd.necrify.api.punishment.Mute;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.PunishmentTypeRegistry;
import de.jvstvshd.necrify.api.template.NecrifyTemplate;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserDeletionReason;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.io.Adapters;
import de.jvstvshd.necrify.common.punishment.NecrifyKick;
import de.jvstvshd.necrify.common.punishment.PunishmentBuilder;
import de.jvstvshd.necrify.common.user.MojangAPI;
import de.jvstvshd.necrify.common.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.incendo.cloud.type.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNecrifyUser
implements NecrifyUser {
    private final MessageProvider messageProvider;
    private final AbstractNecrifyPlugin plugin;
    private final List<Punishment> punishments;
    private final Map<NecrifyTemplate, NecrifyTemplateStage> templateStages = new ConcurrentHashMap<NecrifyTemplate, NecrifyTemplateStage>();
    private String username;
    private final UUID uuid;
    private final ExecutorService executor;
    private boolean whitelisted;

    protected AbstractNecrifyUser(UUID uuid, String username, AbstractNecrifyPlugin plugin, boolean whitelisted) {
        this.messageProvider = plugin.getMessageProvider();
        this.plugin = plugin;
        this.username = username;
        this.uuid = uuid;
        this.executor = plugin.getExecutor();
        this.whitelisted = whitelisted;
        this.punishments = Collections.synchronizedList(new ArrayList());
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Override
    @NotNull
    public CompletableFuture<Ban> ban(@Nullable Component reason, @NotNull PunishmentDuration duration) {
        return this.punishCasted(PunishmentBuilder.newBuilder(this.plugin).withDuration(duration).withReason(reason).withUser(this).buildBan());
    }

    @Override
    @NotNull
    public CompletableFuture<Ban> banPermanent(@Nullable Component reason) {
        return this.ban(reason, PunishmentDuration.PERMANENT);
    }

    @Override
    @NotNull
    public CompletableFuture<Mute> mute(@Nullable Component reason, @NotNull PunishmentDuration duration) {
        return this.punishCasted(PunishmentBuilder.newBuilder(this.plugin).withDuration(duration).withReason(reason).withUser(this).buildMute());
    }

    @Override
    @NotNull
    public CompletableFuture<Mute> mutePermanent(@Nullable Component reason) {
        return this.mute(reason, PunishmentDuration.PERMANENT);
    }

    @Override
    @NotNull
    public CompletableFuture<Kick> kick(@Nullable Component reason) {
        NecrifyKick kick = PunishmentBuilder.newBuilder(this.plugin).withReason(reason).withUser(this).buildKick();
        kick.punish();
        return CompletableFuture.completedFuture(kick);
    }

    @NotNull
    public <T extends Punishment> CompletableFuture<T> punishCasted(Punishment punishment) {
        return this.punish(punishment);
    }

    @Override
    @NotNull
    public CompletableFuture<Punishment> punish(@NotNull Punishment punishment) {
        this.punishments.add(punishment);
        return punishment.punish();
    }

    @Override
    @NotNull
    public <T extends Punishment> List<T> getPunishments(PunishmentType ... types) {
        this.validatePunishments();
        if (types == null || types.length == 0) {
            return ImmutableList.copyOf(this.punishments);
        }
        return ImmutableList.copyOf(this.punishments.stream().filter(punishment -> {
            for (PunishmentType type : types) {
                if (!punishment.getType().equals(type)) continue;
                return true;
            }
            return false;
        }).toList());
    }

    protected synchronized void validatePunishments() {
        this.punishments.removeIf(punishment -> !punishment.isOngoing());
    }

    @Override
    @NotNull
    public Optional<NecrifyTemplateStage> getCurrentTemplateStage(@NotNull NecrifyTemplate template) {
        return Optional.ofNullable(this.templateStages.get(template));
    }

    @Override
    @NotNull
    public NecrifyTemplateStage getNextTemplateStage(@NotNull NecrifyTemplate template) {
        try {
            if (this.templateStages.containsKey(template)) {
                return this.templateStages.get(template).nextOrThis();
            }
            return template.getStage(0);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Punishment> punishModelled(@NotNull NecrifyTemplate template) {
        NecrifyTemplateStage nextStage = this.getNextTemplateStage(template);
        Map<String, Component> data = Map.of("user", this, "duration", nextStage.duration(), "punishmentUuid", UUID.randomUUID(), "reason", nextStage.reason());
        Punishment punishment = PunishmentTypeRegistry.createPunishment(nextStage.punishmentType(), data);
        return punishment.punish().whenComplete((punishment1, throwable) -> {
            NecrifyTemplateStage secondNextStage = nextStage.nextOrThis();
            if (secondNextStage.equals(nextStage)) {
                return;
            }
            this.updateUserStage(nextStage);
        });
    }

    @Override
    public CompletableFuture<Void> amnesty(@NotNull NecrifyTemplate template, int stageIndex) {
        if (stageIndex < 0) {
            throw new IllegalArgumentException("stageIndex must be >= 0");
        }
        if (stageIndex > template.stages().size() - 1) {
            throw new IllegalArgumentException("stageIndex must be < " + template.stages().size());
        }
        if (this.templateStages.containsKey(template)) {
            if (this.templateStages.get(template).index() == stageIndex - 1) {
                return CompletableFuture.completedFuture(null);
            }
            if (stageIndex == 0) {
                return Util.executeAsync(() -> {
                    Query.query((String)"DELETE FROM necrify_punishment_template_user_stage WHERE user_id = ? AND template_id = (SELECT id FROM necrify_punishment_template WHERE name = ?);", (Object[])new Object[0]).single(Call.of().bind((Object)this.uuid, Adapters.UUID_ADAPTER).bind(template.name())).update();
                    this.templateStages.remove(template);
                    return null;
                }, this.executor);
            }
            NecrifyTemplateStage newStage = template.getStage(stageIndex - 1);
            return this.updateUserStage(newStage).thenAccept(unused -> this.templateStages.put(template, newStage));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> updateUserStage(NecrifyTemplateStage stage) {
        return Util.executeAsync(() -> {
            Query.query((String)"WITH template_data AS (SELECT id FROM necrify_punishment_template t WHERE t.name = ?), stage_data AS (SELECT id FROM necrify_punishment_template_stage s WHERE s.template_id = (SELECT id FROM template_data) AND s.index = ?) INSERT INTO necrify_punishment_template_user_stage (user_id, template_id, stage_id) VALUES (?, (SELECT id FROM template_data), (SELECT id FROM stage_data))ON CONFLICT (user_id, template_id) DO UPDATE SET stage_id = (SELECT id FROM stage_data);", (Object[])new Object[0]).single(Call.of().bind(stage.template().name()).bind(Integer.valueOf(stage.index())).bind((Object)this.uuid, Adapters.UUID_ADAPTER)).update();
            this.templateStages.put(stage.template(), stage);
            return null;
        }, this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<String> queryUsername(boolean update) {
        return MojangAPI.getPlayerNameAsync(this.uuid, this.executor).thenApplyAsync(s -> {
            if (update) {
                this.username = s.orElse(null);
            }
            return s.orElse(null);
        });
    }

    @Override
    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    @Override
    public CompletableFuture<Boolean> setWhitelisted(boolean whitelisted) {
        if (whitelisted == this.whitelisted) {
            CompletableFuture.completedFuture(false);
        }
        return Util.executeAsync(() -> {
            Query.query((String)"UPDATE necrify_user SET whitelisted = ? WHERE uuid = ?;", (Object[])new Object[0]).single(Call.of().bind(Boolean.valueOf(whitelisted)).bind((Object)this.uuid, Adapters.UUID_ADAPTER)).update();
            this.whitelisted = whitelisted;
            if (!whitelisted && this.plugin.isWhitelistActive()) {
                this.kick(this.messageProvider.provide("whitelist.removed", new Component[0]).color((TextColor)NamedTextColor.RED));
            }
            return true;
        }, this.executor);
    }

    public void addPunishment(Punishment punishment) {
        if (this.punishments.contains(punishment)) {
            return;
        }
        this.punishments.add(punishment);
    }

    public void removePunishment(Punishment punishment) {
        this.punishments.remove(punishment);
    }

    @Override
    public CompletableFuture<Integer> delete(@NotNull UserDeletionReason reason) {
        this.plugin.getEventDispatcher().dispatch(new UserDeletedEvent(this, reason));
        return Util.executeAsync(() -> Query.query((String)"DELETE FROM necrify_user WHERE uuid = ?;", (Object[])new Object[0]).single(Call.of().bind((Object)this.uuid, Adapters.UUID_ADAPTER)).delete().rows() + this.punishments.size(), this.executor);
    }

    public abstract void executeOnAudience(@NotNull Consumer<Audience> var1);

    public MessageProvider getProvider() {
        return this.messageProvider;
    }

    public CompletableFuture<Void> loadTemplateStages() {
        return Util.executeAsync(() -> {
            Query.query((String)"SELECT template.name, stage.index FROM necrify_punishment_template_stage stage, necrify_punishment_template template, necrify_punishment_template_user_stage users WHERE users.user_id = ? AND template.id = users.template_id AND stage.template_id = template.id", (Object[])new Object[0]).single(Call.of().bind((Object)this.uuid, Adapters.UUID_ADAPTER)).map(row -> {
                Optional<NecrifyTemplate> template = this.plugin.getTemplateManager().getTemplate(row.getString(1));
                if (template.isEmpty()) {
                    this.plugin.getLogger().warn("Template {} not found for user {}", (Object)row.getString(1), (Object)this.uuid);
                    return null;
                }
                try {
                    NecrifyTemplateStage stage = template.get().getStage(row.getInt(2));
                    return Pair.of((Object)template.get(), (Object)stage);
                }
                catch (IndexOutOfBoundsException | NoSuchElementException e) {
                    this.plugin.getLogger().warn("Template stage {} not found in template {} for user {}", new Object[]{row.getInt(2), template.get().name(), this.uuid});
                    return null;
                }
            }).all().forEach(pair -> {
                if (pair == null) {
                    return;
                }
                this.templateStages.put((NecrifyTemplate)pair.first(), (NecrifyTemplateStage)pair.second());
            });
            return null;
        }, this.executor);
    }

    @Override
    public void sendMessage(@NotNull String key, TextColor color, Component ... args) {
        this.sendMessage(this.messageProvider.provide(key, args).color(color));
    }

    @Override
    public void sendErrorMessage() {
        this.sendMessage(this.messageProvider.internalError());
    }

    public void sendMessage(@NotNull Component message) {
        this.executeOnAudience(audience -> audience.sendMessage(message));
    }

    public void sendMessage(@NotNull Identified source, @NotNull Component message) {
        this.executeOnAudience(audience -> audience.sendMessage(source, message));
    }

    public void sendMessage(@NotNull Identity source, @NotNull ComponentLike message, @NotNull MessageType type) {
        this.executeOnAudience(audience -> audience.sendMessage(source, message, type));
    }
}

