/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.user;

import com.github.benmanes.caffeine.cache.Cache;
import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.chojo.sadu.queries.api.results.writing.insertion.InsertionResult;
import de.jvstvshd.necrify.api.event.origin.EventOrigin;
import de.jvstvshd.necrify.api.event.user.UserLoadedEvent;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserManager;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.io.Adapters;
import de.jvstvshd.necrify.common.user.AbstractNecrifyUser;
import de.jvstvshd.necrify.common.user.MojangAPI;
import de.jvstvshd.necrify.common.user.UserLoader;
import de.jvstvshd.necrify.common.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUserManager<T extends NecrifyUser>
implements UserManager {
    @Language(value="sql")
    private static final String SELECT_USER_QUERY = "SELECT name, whitelisted FROM necrify_user WHERE uuid = ?;";
    @Language(value="sql")
    private static final String SELECT_USER_BY_NAME_QUERY = "SELECT uuid, whitelisted FROM necrify_user WHERE LOWER(name) = ?";
    @Language(value="sql")
    private static final String SELECT_USER_PUNISHMENTS_QUERY = "SELECT type, expiration, reason, punishment_id, successor, issued_at FROM necrify_punishment WHERE uuid = ?;";
    @Language(value="sql")
    private static final String INSERT_NEW_USER = "INSERT INTO necrify_user (uuid, name, whitelisted) VALUES (?, ?, ?);";
    private final ExecutorService executor;
    private final Cache<UUID, T> userCache;
    private final Cache<String, UUID> nameCache;
    private final AbstractNecrifyPlugin plugin;

    public AbstractUserManager(ExecutorService executor, Cache<UUID, T> userCache, Cache<String, UUID> nameCache, AbstractNecrifyPlugin plugin) {
        this.executor = executor;
        this.userCache = userCache;
        this.nameCache = nameCache;
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public Optional<NecrifyUser> getUser(@NotNull UUID uuid) {
        return Optional.ofNullable((NecrifyUser)this.userCache.getIfPresent((Object)uuid));
    }

    @Override
    @NotNull
    public Optional<NecrifyUser> getUser(@NotNull String player) {
        UUID uuid = this.tryAcquireUuid(player);
        if (uuid != null) {
            return this.getUser(uuid);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> loadUser(@NotNull UUID uuid) {
        Optional<NecrifyUser> cached = this.getUser(uuid);
        if (cached.isPresent()) {
            return CompletableFuture.completedFuture(cached);
        }
        return Util.executeAsync(() -> {
            Optional user = Query.query((String)SELECT_USER_QUERY, (Object[])new Object[0]).single(Call.of().bind((Object)uuid, Adapters.UUID_ADAPTER)).map(row -> this.constructUser(uuid, row.getString(1), row.getBoolean(2), this.plugin)).first();
            user.ifPresent(velocityUser -> {
                UserLoader loader = new UserLoader((NecrifyUser)velocityUser);
                Query.query((String)SELECT_USER_PUNISHMENTS_QUERY, (Object[])new Object[0]).single(Call.of().bind((Object)uuid, Adapters.UUID_ADAPTER)).map(loader::addDataFromRow).all();
                this.loadPunishmentsToUser(loader);
            });
            return user.map(velocityUser -> {
                this.cache(velocityUser);
                this.plugin.getEventDispatcher().dispatch(new UserLoadedEvent((NecrifyUser)velocityUser).setOrigin(EventOrigin.ofClass(this.getClass())));
                return velocityUser;
            });
        }, this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> loadUser(@NotNull String player) {
        String pl = player.toLowerCase(Locale.ROOT);
        Optional<NecrifyUser> cached = this.getUser(pl);
        if (cached.isPresent()) {
            return CompletableFuture.completedFuture(cached);
        }
        UUID parsedUuid = Util.parseUuid(pl);
        if (parsedUuid != null) {
            return this.loadUser(parsedUuid);
        }
        return Util.executeAsync(() -> {
            Optional user = Query.query((String)SELECT_USER_BY_NAME_QUERY, (Object[])new Object[0]).single(Call.of().bind(pl)).map(row -> this.constructUser(Util.getUuid(row, 1), pl, row.getBoolean(2), this.plugin)).first();
            user.ifPresent(velocityUser -> {
                UserLoader loader = new UserLoader((NecrifyUser)velocityUser);
                Query.query((String)SELECT_USER_PUNISHMENTS_QUERY, (Object[])new Object[0]).single(Call.of().bind((Object)velocityUser.getUuid(), Adapters.UUID_ADAPTER)).map(loader::addDataFromRow).all();
                this.loadPunishmentsToUser(loader);
            });
            return user.map(velocityUser -> {
                this.cache(velocityUser);
                this.plugin.getEventDispatcher().dispatch(new UserLoadedEvent((NecrifyUser)velocityUser).setOrigin(EventOrigin.ofClass(this.getClass())));
                return velocityUser;
            });
        }, this.executor);
    }

    @Override
    public Optional<NecrifyUser> getUserByPunishmentId(@NotNull UUID uuid) {
        return this.userCache.asMap().values().stream().flatMap(t -> t.getPunishments(new PunishmentType[0]).stream()).filter(punishment -> punishment.getUuid() == uuid).findFirst().map(Punishment::getUser);
    }

    @Override
    public CompletableFuture<Optional<NecrifyUser>> loadUserByPunishmentId(@NotNull UUID uuid) {
        Optional<NecrifyUser> optional = this.getUserByPunishmentId(uuid);
        if (optional.isPresent()) {
            return CompletableFuture.completedFuture(optional);
        }
        return Util.executeAsync(() -> {
            Optional user = Query.query((String)"SELECT necrify_user.* FROM necrify_user, necrify_punishment WHERE necrify_punishment.punishment_id = ? AND necrify_punishment.uuid = necrify_user.uuid", (Object[])new Object[0]).single(Call.of().bind((Object)uuid, Adapters.UUID_ADAPTER)).map(row -> this.constructUser(uuid, row.getString(1), row.getBoolean(2), this.plugin)).first();
            user.ifPresent(velocityUser -> {
                UserLoader loader = new UserLoader((NecrifyUser)velocityUser);
                Query.query((String)SELECT_USER_PUNISHMENTS_QUERY, (Object[])new Object[0]).single(Call.of().bind((Object)uuid, Adapters.UUID_ADAPTER)).map(loader::addDataFromRow).all();
                this.loadPunishmentsToUser(loader);
            });
            return user.map(this::cache);
        }, this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> createUser(@NotNull UUID uuid) {
        return Util.executeAsync(() -> {
            Optional<String> name = MojangAPI.getPlayerName(uuid);
            return name.map(s -> this.createUser(uuid, (String)s));
        }, this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> createUser(@NotNull String player) {
        UUID parsedUuid = Util.parseUuid(player);
        if (parsedUuid != null) {
            return this.loadUser(parsedUuid);
        }
        return Util.executeAsync(() -> {
            Optional<UUID> uuid = MojangAPI.getUuid(player);
            return uuid.map(id -> this.createUser((UUID)id, player));
        }, this.executor);
    }

    private NecrifyUser createUser(UUID uuid, String playerName) {
        InsertionResult result = Query.query((String)INSERT_NEW_USER, (Object[])new Object[0]).single(Call.of().bind((Object)uuid, Adapters.UUID_ADAPTER).bind(playerName).bind(Boolean.valueOf(false))).insert();
        if (result.hasExceptions()) {
            throw new RuntimeException("failed to create user", (Throwable)result.exceptions().getFirst());
        }
        if (!result.changed()) {
            throw new IllegalStateException("User does already exist");
        }
        T user = this.constructUser(uuid, playerName, false, this.plugin);
        this.plugin.getEventDispatcher().dispatch(new UserLoadedEvent((NecrifyUser)user));
        return this.cache(user);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> loadOrCreateUser(@NotNull UUID uuid) {
        return this.loadUser(uuid).thenApplyAsync(optional -> optional.or(() -> this.createUser(uuid).join()), (Executor)this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<NecrifyUser>> loadOrCreateUser(@NotNull String player) {
        return this.loadUser(player).thenApplyAsync(optional -> optional.or(() -> this.createUser(player).join()), (Executor)this.executor);
    }

    @Nullable
    private UUID tryAcquireUuid(String name) {
        Optional<UUID> parsed = Util.fromString(name);
        return parsed.orElseGet(() -> this.getUuidIfOnline(name).orElseGet(() -> (UUID)this.nameCache.getIfPresent((Object)name.toLowerCase(Locale.ROOT))));
    }

    protected T cache(@NotNull T user) {
        this.userCache.put((Object)user.getUuid(), user);
        if (user.getUsername() != null) {
            this.nameCache.put((Object)user.getUsername().toLowerCase(Locale.ROOT), (Object)user.getUuid());
        }
        return user;
    }

    public void loadPunishmentsToUser(UserLoader loader) {
        List<UUID> invalidPunishments = loader.getInvalidPunishments();
        List<Punishment> punishments = loader.loadPunishments();
        if (!invalidPunishments.isEmpty()) {
            this.plugin.getExecutor().submit(() -> invalidPunishments.stream().map(uuid -> punishments.stream().filter(punishment -> punishment.getUuid().equals(uuid)).findFirst().orElse(null)).forEach(punishment -> {
                if (punishment != null) {
                    punishment.cancel().join();
                }
            }));
        }
        for (Punishment loadedPunishment : loader.loadPunishments()) {
            if (!loadedPunishment.isOngoing()) continue;
            ((AbstractNecrifyUser)loader.getUser()).addPunishment(loadedPunishment);
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Cache<UUID, T> getUserCache() {
        return this.userCache;
    }

    public Cache<String, UUID> getNameCache() {
        return this.nameCache;
    }

    public AbstractNecrifyPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Collection<? extends NecrifyUser> getLoadedUsers() {
        return this.userCache.asMap().values();
    }

    public abstract Optional<UUID> getUuidIfOnline(String var1);

    public abstract T constructUser(UUID var1, String var2, boolean var3, AbstractNecrifyPlugin var4);
}

