/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.user;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class MojangAPI {
    @NotNull
    public static Optional<String> getPlayerName(@NotNull UUID uuid) throws IOException, InterruptedException {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid))).GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            Optional<String> optional = MojangAPI.getPlayerName(response);
            return optional;
        }
    }

    @NotNull
    public static CompletableFuture<Optional<String>> getPlayerNameAsync(@NotNull UUID uuid, ExecutorService executor) {
        try (HttpClient httpClient = HttpClient.newBuilder().executor(executor).build();){
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid))).GET().build();
            CompletionStage completionStage = httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(MojangAPI::getPlayerName);
            return completionStage;
        }
    }

    @NotNull
    private static Optional<String> getPlayerName(HttpResponse<String> response) {
        if (response.statusCode() != 200) {
            return Optional.empty();
        }
        JsonElement jsonElement = JsonParser.parseString((String)response.body());
        JsonElement nameElement = jsonElement.getAsJsonObject().get("name");
        if (nameElement == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nameElement.getAsString());
    }

    @NotNull
    public static Optional<UUID> getUuid(@NotNull String name) throws IOException, InterruptedException {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            UUID uuid;
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://api.mojang.com/users/profiles/minecraft/" + name)).GET().build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            JsonElement jsonElement = JsonParser.parseString((String)response.body());
            if (jsonElement == null || jsonElement.isJsonNull()) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            JsonElement idElement = jsonElement.getAsJsonObject().get("id");
            if (idElement == null) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            String result = idElement.getAsString();
            try {
                uuid = UUID.fromString(result);
            }
            catch (IllegalArgumentException e) {
                uuid = UUID.fromString(result.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            }
            Optional<UUID> optional = Optional.of(uuid);
            return optional;
        }
    }
}

