/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.user;

import de.chojo.sadu.queries.api.call.Call;
import de.chojo.sadu.queries.api.query.Query;
import de.jvstvshd.necrify.api.event.EventDispatcher;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLogEntry;
import de.jvstvshd.necrify.api.user.UserManager;
import de.jvstvshd.necrify.common.AbstractNecrifyPlugin;
import de.jvstvshd.necrify.common.event.PostgresPunishmentLogUpdateEvent;
import de.jvstvshd.necrify.common.punishment.log.NecrifyPunishmentLog;
import de.jvstvshd.necrify.common.util.Util;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.slf4j.Logger;

public class PostgresPunishmentLogUpdater
implements Callable<Void> {
    public static final String CHANNEL_NAME = "necrify_punishment_log_update";
    private final DataSource dataSource;
    private final UserManager userManager;
    private final EventDispatcher dispatcher;
    private final Logger logger;
    private final AbstractNecrifyPlugin plugin;

    public PostgresPunishmentLogUpdater(UserManager userManager, DataSource dataSource, AbstractNecrifyPlugin plugin) {
        this.dataSource = dataSource;
        this.userManager = userManager;
        this.dispatcher = plugin.getEventDispatcher();
        this.logger = plugin.getLogger();
        this.plugin = plugin;
    }

    @Override
    public Void call() throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            try (Statement statement = connection.createStatement();){
                statement.execute("LISTEN necrify_punishment_log_update");
                while (!Thread.currentThread().isInterrupted()) {
                    PGNotification[] notifications;
                    for (PGNotification notification : notifications = pgConnection.getNotifications()) {
                        this.handleNotification(notification.getParameter());
                    }
                }
            }
        }
        return null;
    }

    private void handleNotification(String notification) {
        String[] split = notification.split(" ");
        if (split.length != 2) {
            return;
        }
        try {
            UUID uuid = UUID.fromString(split[0]);
            int id = Integer.parseInt(split[1]);
            Punishment punishment = this.getPunishment(uuid);
            if (punishment == null) {
                return;
            }
            NecrifyPunishmentLog log = Util.getCachedLog(punishment);
            if (log == null) {
                return;
            }
            Optional result = Query.query((String)"SELECT id, actor_id, message, expiration, reason, predecessor, successor, action, begins_at, created_at FROM punishment_log WHERE id = ?;", (Object[])new Object[0]).single(Call.of().bind(Integer.valueOf(id))).map(row -> NecrifyPunishmentLog.fromRow(row, this.plugin, log, punishment, log.getEntries().size())).first();
            result.ifPresent(punishmentLogEntry -> this.dispatcher.dispatch(new PostgresPunishmentLogUpdateEvent(punishment, (PunishmentLogEntry)punishmentLogEntry)));
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while handling the notification: ", (Throwable)e);
        }
    }

    private Punishment getPunishment(UUID uuid) {
        return this.userManager.getLoadedUsers().stream().flatMap(user -> user.getPunishments(new PunishmentType[0]).stream()).filter(punishment -> punishment.getPunishmentUuid().equals(uuid)).findFirst().orElse(null);
    }
}

