/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.user;

import de.chojo.sadu.mapper.wrapper.Row;
import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentTypeRegistry;
import de.jvstvshd.necrify.api.punishment.StandardPunishmentType;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import de.jvstvshd.necrify.api.user.UserLoadOrderCoordinator;
import de.jvstvshd.necrify.common.util.Util;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public final class UserLoader {
    private final List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
    private final List<UUID> invalidPunishments = new ArrayList<UUID>();
    private final NecrifyUser user;

    public UserLoader(NecrifyUser user) {
        this.user = user;
    }

    public void addData(Map<String, Object> data) {
        this.data.add(data);
    }

    public Void addDataFromRow(Row row) {
        try {
            final StandardPunishmentType type = PunishmentTypeRegistry.getType(row.getInt(1)).standard();
            Timestamp timestamp = row.getTimestamp(2);
            final PunishmentDuration duration = PunishmentDuration.fromTimestamp(timestamp);
            final Component reason = MiniMessage.miniMessage().deserialize((Object)row.getString(3));
            final UUID punishmentUuid = Util.getUuid(row, 4);
            final UUID successorId = Util.getUuid(row, 5);
            final LocalDateTime issuedAt = row.getTimestamp(6).toLocalDateTime();
            if (duration.expiration().isBefore(LocalDateTime.now())) {
                this.invalidPunishments.add(punishmentUuid);
            }
            HashMap<String, Object> data = new HashMap<String, Object>(){
                {
                    this.put("type", type);
                    this.put("duration", duration);
                    this.put("reason", reason);
                    this.put("punishmentUuid", punishmentUuid);
                    this.put("user", UserLoader.this.user);
                    this.put("successorId", successorId);
                    this.put("issued_at", issuedAt);
                }
            };
            this.addData((Map<String, Object>)data);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public List<Punishment> loadPunishments() {
        List<Map<String, Object>> ordered = UserLoadOrderCoordinator.topologicalSort(this.data);
        HashMap<UUID, Punishment> loaded = new HashMap<UUID, Punishment>();
        for (Map<String, Object> dataMap : ordered) {
            StandardPunishmentType type = (StandardPunishmentType)dataMap.get("type");
            if (dataMap.get("successorId") != null) {
                Punishment successor = (Punishment)loaded.get((UUID)dataMap.get("successorId"));
                dataMap.put("successor", successor);
            }
            Punishment punishment = PunishmentTypeRegistry.createPunishment(type, dataMap);
            loaded.put(punishment.getPunishmentUuid(), punishment);
        }
        return new ArrayList<Punishment>(loaded.values());
    }

    public NecrifyUser getUser() {
        return this.user;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public List<UUID> getInvalidPunishments() {
        return this.invalidPunishments;
    }
}

