/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.util;

import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.user.NecrifyUser;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

public class Paginator {
    private final PageProvider provider;
    private final int pages;
    private final MessageProvider messageProvider;

    public Paginator(PageProvider provider, int pages, MessageProvider messageProvider) {
        this.provider = provider;
        this.pages = pages;
        this.messageProvider = messageProvider;
    }

    public void showTo(NecrifyUser user, int startAtPage) {
    }

    public void showPageTo(NecrifyUser user, int page) {
        user.sendMessage(this.provider.createPage(page));
    }

    public Component surroundWithPaginating(Component component) {
        return ((TextComponent.Builder)Component.text().append(new Component[]{Component.newline(), component, Component.newline()})).build();
    }

    public Component createHeader(int page) {
        return this.messageProvider.provide("paginator.header", new Component[]{Component.text((int)page), Component.text((int)this.pages)});
    }

    public Component createFooter(int page) {
        return this.messageProvider.provide("paginator.footer", new Component[]{Component.text((int)page), Component.text((int)this.pages)});
    }

    public static interface PageProvider {
        public Component createPage(int var1);
    }
}

