/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.util;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.PunishmentType;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import de.jvstvshd.necrify.api.template.NecrifyTemplateStage;
import de.jvstvshd.necrify.common.util.Util;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class PunishmentHelper {
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");

    private PunishmentHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Component buildPunishmentData(Punishment punishment, MessageProvider provider) {
        return PunishmentHelper.buildPunishmentData(punishment, provider, 0);
    }

    public static Component buildPunishmentData(Punishment punishment, MessageProvider messageProvider, int indents) {
        TextComponent textComponent;
        MessageProvider provider = indents == 0 ? messageProvider : messageProvider.autoPrefixed(false);
        Component ic = PunishmentHelper.indentComponent(indents);
        Component clickToRemove = provider.provide("command.punishment.click-to-remove", new Component[0]);
        TextComponent.Builder builder = Component.text();
        Component[] componentArray = new Component[13];
        componentArray[0] = ic;
        componentArray[1] = provider.provide("helper.type", new Component[0]).color((TextColor)NamedTextColor.AQUA);
        componentArray[2] = PunishmentHelper.buildPunishmentTypeInformation(punishment.getType(), provider);
        componentArray[3] = Component.newline();
        componentArray[4] = ic;
        componentArray[5] = provider.provide("helper.reason", new Component[0]).color((TextColor)NamedTextColor.AQUA);
        componentArray[6] = Util.copyComponent(punishment.getReason(), PlainTextComponentSerializer.plainText().serialize(punishment.getReason()), provider);
        componentArray[7] = Component.newline();
        componentArray[8] = ic;
        componentArray[9] = provider.provide("ID: ", new Component[0]).color((TextColor)NamedTextColor.AQUA);
        componentArray[10] = PunishmentHelper.copyable(punishment.getPunishmentUuid().toString(), NamedTextColor.YELLOW, provider);
        componentArray[11] = Component.newline();
        if (punishment instanceof TemporalPunishment) {
            TemporalPunishment temporalPunishment = (TemporalPunishment)punishment;
            textComponent = PunishmentHelper.buildPunishmentDataTemporal(temporalPunishment, provider, ic);
        } else {
            textComponent = Component.text((String)"");
        }
        componentArray[12] = textComponent;
        TextComponent.Builder builder2 = (TextComponent.Builder)builder.append(componentArray);
        if (punishment.isOngoing()) {
            builder2.append(new Component[]{Component.newline(), ic, clickToRemove.color((TextColor)NamedTextColor.RED).clickEvent(ClickEvent.runCommand((String)("/necrify punishment " + punishment.getPunishmentUuid().toString().toLowerCase(Locale.ROOT) + " remove"))).hoverEvent(op -> HoverEvent.showText((Component)clickToRemove.color((TextColor)NamedTextColor.GREEN))), Component.text((String)" | ", (TextColor)NamedTextColor.GRAY)});
        } else {
            builder2.append((Component)Component.newline());
        }
        builder2.append(new Component[]{provider.provide("helper.view-log", false, new Component[0]).color((TextColor)NamedTextColor.GRAY).clickEvent(ClickEvent.runCommand((String)("/necrify punishment " + punishment.getPunishmentUuid().toString().toLowerCase(Locale.ROOT) + " log"))), Component.newline()});
        if (punishment.hasSuccessor()) {
            int newIndenting = indents == 0 ? 6 : indents + 3;
            Component child = PunishmentHelper.buildPunishmentData(punishment.getSuccessor(), provider, newIndenting);
            ((TextComponent.Builder)builder2.append(new Component[]{ic, provider.provide("helper.successor", new Component[0]).color((TextColor)NamedTextColor.AQUA), Component.newline()})).append(child);
        }
        return builder2.build();
    }

    public static Component buildPunishmentDataTemporal(TemporalPunishment punishment, MessageProvider provider, Component linePrefix) {
        if (punishment.isPermanent()) {
            return ((TextComponent.Builder)Component.text().append(new Component[]{linePrefix, provider.provide("helper.temporal.duration", new Component[0]).color((TextColor)NamedTextColor.AQUA), Component.text((String)"PERMANENT").color((TextColor)NamedTextColor.RED)})).build();
        }
        return ((TextComponent.Builder)Component.text().append(new Component[]{linePrefix, provider.provide("helper.temporal.duration", new Component[0]).color((TextColor)NamedTextColor.AQUA), Component.text((String)punishment.getDuration().remainingDuration()).color((TextColor)NamedTextColor.YELLOW), Component.newline(), linePrefix, provider.provide("helper.temporal.end", new Component[0]).color((TextColor)NamedTextColor.AQUA), Component.text((String)punishment.getDuration().expirationAsString()).color((TextColor)NamedTextColor.YELLOW)})).build();
    }

    public static Component indentComponent(int n) {
        if (n == 0) {
            return Component.empty();
        }
        return Component.text((String)(" ".repeat(n) + "> ")).color((TextColor)NamedTextColor.GRAY);
    }

    public static Component buildPunishmentTypeInformation(PunishmentType type, MessageProvider provider) {
        return PunishmentHelper.copyable("%s (%d)".formatted(type.getName(), type.getId()), NamedTextColor.YELLOW, provider);
    }

    public static Component buildTemplateStageInformation(NecrifyTemplateStage stage, MessageProvider provider) {
        return provider.provide("command.template.stage.info", new Component[]{Component.text((int)(stage.index() + 1), (TextColor)NamedTextColor.YELLOW), stage.reason(), Component.text((String)stage.duration().remainingDuration(PunishmentDuration.StringRepresentation.SHORT), (TextColor)NamedTextColor.YELLOW), PunishmentHelper.buildPunishmentTypeInformation(stage.punishmentType(), provider)}).color((TextColor)NamedTextColor.GRAY);
    }

    private static Component copyable(String s, NamedTextColor color, MessageProvider provider) {
        return Util.copyComponent(s, provider).color((TextColor)color);
    }
}

