/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.common.util;

import de.chojo.sadu.core.conversion.UUIDConverter;
import de.chojo.sadu.mapper.wrapper.Row;
import de.jvstvshd.necrify.api.message.MessageProvider;
import de.jvstvshd.necrify.api.punishment.Punishment;
import de.jvstvshd.necrify.api.punishment.TemporalPunishment;
import de.jvstvshd.necrify.api.punishment.log.PunishmentLog;
import de.jvstvshd.necrify.common.io.NecrifyDatabase;
import de.jvstvshd.necrify.common.punishment.AbstractPunishment;
import de.jvstvshd.necrify.common.punishment.log.NecrifyPunishmentLog;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final UUID NULL_UUID = new UUID(0L, 0L);
    public static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");

    private Util() {
    }

    public static UUID getUuid(Row row, int index) throws SQLException {
        return switch (NecrifyDatabase.SQL_TYPE.toLowerCase(Locale.ROOT)) {
            case "postgres", "postgresql" -> (UUID)row.getObject(index, UUID.class);
            case "mysql" -> UUIDConverter.convert((byte[])row.getBytes(index));
            default -> {
                String uuidBytes = row.getString(index);
                if (uuidBytes == null) {
                    yield null;
                }
                yield UUID.fromString(uuidBytes);
            }
        };
    }

    public static UUID parseUuid(String uuidString) {
        try {
            return UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            try {
                return UUID.fromString(uuidString.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static <T> CompletableFuture<T> executeAsync(Callable<T> task, Executor service) {
        CompletableFuture cf = new CompletableFuture();
        service.execute(() -> {
            try {
                cf.complete(task.call());
            }
            catch (Throwable e) {
                cf.completeExceptionally(e);
            }
        });
        return cf;
    }

    public static TextComponent copyComponent(String text, MessageProvider provider) {
        return (TextComponent)((TextComponent)Component.text((String)text).clickEvent(ClickEvent.suggestCommand((String)text))).hoverEvent(op -> HoverEvent.showText((Component)provider.provide("commands.general.copy", new Component[0]).color((TextColor)NamedTextColor.GREEN)));
    }

    public static Component copyComponent(Component base, String copy, MessageProvider provider) {
        return base.clickEvent(ClickEvent.suggestCommand((String)copy)).hoverEvent(op -> HoverEvent.showText((Component)provider.provide("commands.general.copy", new Component[0]).color((TextColor)NamedTextColor.GREEN)));
    }

    public static Component copyComponent(Component base, Component copy, MessageProvider provider) {
        return base.clickEvent(ClickEvent.suggestCommand((String)PlainTextComponentSerializer.plainText().serialize(copy))).hoverEvent(op -> HoverEvent.showText((Component)provider.provide("commands.general.copy", new Component[0]).color((TextColor)NamedTextColor.GREEN)));
    }

    public static Optional<UUID> fromString(String uuidString) {
        UUID uuid;
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            try {
                uuid = UUID.fromString(uuidString.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
            }
            catch (Exception ex) {
                return Optional.empty();
            }
        }
        return Optional.of(uuid);
    }

    public static boolean circularSuccessionChain(Punishment base, Punishment successor) {
        Punishment successorsSuccessor = successor;
        do {
            if (!successorsSuccessor.equals(base)) continue;
            return true;
        } while ((successorsSuccessor = Util.successorOrNull(successorsSuccessor)) != null);
        return false;
    }

    @Nullable
    public static Punishment successorOrNull(Punishment punishment) {
        if (punishment.hasSuccessor()) {
            return punishment.getSuccessor();
        }
        return null;
    }

    public static <T extends TemporalPunishment> T getLongestPunishment(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        List<T> sorted = Util.sortPunishments(list);
        return (T)((TemporalPunishment)sorted.getLast());
    }

    public static <T extends TemporalPunishment> List<T> sortPunishments(List<T> list) {
        return list.stream().sorted(Comparator.comparing(TemporalPunishment::getDuration)).collect(Collectors.toList());
    }

    @Nullable
    public static NecrifyPunishmentLog getCachedLog(Punishment punishment) {
        if (!(punishment instanceof AbstractPunishment)) {
            return null;
        }
        AbstractPunishment abstractPunishment = (AbstractPunishment)punishment;
        PunishmentLog cachedLog = abstractPunishment.getCachedLog();
        if (cachedLog == null) {
            return null;
        }
        if (!(cachedLog instanceof NecrifyPunishmentLog)) {
            return null;
        }
        NecrifyPunishmentLog necrifyPunishmentLog = (NecrifyPunishmentLog)cachedLog;
        return necrifyPunishmentLog;
    }
}

