/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.lib.jackson.databind.ext;

import de.jvstvshd.necrify.lib.jackson.core.JsonGenerator;
import de.jvstvshd.necrify.lib.jackson.core.JsonToken;
import de.jvstvshd.necrify.lib.jackson.core.type.WritableTypeId;
import de.jvstvshd.necrify.lib.jackson.databind.SerializerProvider;
import de.jvstvshd.necrify.lib.jackson.databind.jsontype.TypeSerializer;
import de.jvstvshd.necrify.lib.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.nio.file.Path;

public class NioPathSerializer
extends StdScalarSerializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathSerializer() {
        super(Path.class);
    }

    @Override
    public void serialize(Path value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(value.toUri().toString());
    }

    @Override
    public void serializeWithType(Path value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, Path.class, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }
}

