/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.lib.jackson.databind.ser.std;

import de.jvstvshd.necrify.lib.jackson.core.JsonGenerator;
import de.jvstvshd.necrify.lib.jackson.core.JsonToken;
import de.jvstvshd.necrify.lib.jackson.core.type.WritableTypeId;
import de.jvstvshd.necrify.lib.jackson.databind.JavaType;
import de.jvstvshd.necrify.lib.jackson.databind.JsonMappingException;
import de.jvstvshd.necrify.lib.jackson.databind.JsonNode;
import de.jvstvshd.necrify.lib.jackson.databind.SerializerProvider;
import de.jvstvshd.necrify.lib.jackson.databind.annotation.JacksonStdImpl;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.jvstvshd.necrify.lib.jackson.databind.jsontype.TypeSerializer;
import de.jvstvshd.necrify.lib.jackson.databind.node.ObjectNode;
import de.jvstvshd.necrify.lib.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

