/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.lib.jackson.databind.ser.std;

import de.jvstvshd.necrify.lib.jackson.core.JsonGenerator;
import de.jvstvshd.necrify.lib.jackson.databind.JavaType;
import de.jvstvshd.necrify.lib.jackson.databind.JsonMappingException;
import de.jvstvshd.necrify.lib.jackson.databind.SerializerProvider;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import de.jvstvshd.necrify.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.jvstvshd.necrify.lib.jackson.databind.ser.std.StdScalarSerializer;
import de.jvstvshd.necrify.lib.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

