/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.lib.jackson.datatype.jsr310.deser;

import de.jvstvshd.necrify.lib.jackson.annotation.JsonFormat;
import de.jvstvshd.necrify.lib.jackson.core.JsonParser;
import de.jvstvshd.necrify.lib.jackson.core.JsonToken;
import de.jvstvshd.necrify.lib.jackson.core.StreamReadCapability;
import de.jvstvshd.necrify.lib.jackson.core.io.NumberInput;
import de.jvstvshd.necrify.lib.jackson.databind.BeanProperty;
import de.jvstvshd.necrify.lib.jackson.databind.DeserializationContext;
import de.jvstvshd.necrify.lib.jackson.databind.DeserializationFeature;
import de.jvstvshd.necrify.lib.jackson.databind.JsonDeserializer;
import de.jvstvshd.necrify.lib.jackson.databind.JsonMappingException;
import de.jvstvshd.necrify.lib.jackson.databind.deser.ContextualDeserializer;
import de.jvstvshd.necrify.lib.jackson.datatype.jsr310.DecimalUtils;
import de.jvstvshd.necrify.lib.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import de.jvstvshd.necrify.lib.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.util.Objects;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();
    protected final DurationUnitConverter _durationUnitConverter;
    protected final Boolean _readTimestampsAsNanosOverride;

    public DurationDeserializer() {
        super(Duration.class);
        this._durationUnitConverter = null;
        this._readTimestampsAsNanosOverride = null;
    }

    protected DurationDeserializer(DurationDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._durationUnitConverter = base._durationUnitConverter;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
    }

    protected DurationDeserializer(DurationDeserializer base, DurationUnitConverter converter) {
        super(base, (Boolean)base._isLenient);
        this._durationUnitConverter = converter;
        this._readTimestampsAsNanosOverride = base._readTimestampsAsNanosOverride;
    }

    protected DurationDeserializer(DurationDeserializer base, Boolean leniency, DurationUnitConverter converter, Boolean readTimestampsAsNanosOverride) {
        super(base, leniency);
        this._durationUnitConverter = converter;
        this._readTimestampsAsNanosOverride = readTimestampsAsNanosOverride;
    }

    protected DurationDeserializer withLeniency(Boolean leniency) {
        return new DurationDeserializer(this, leniency);
    }

    protected DurationDeserializer withConverter(DurationUnitConverter converter) {
        return new DurationDeserializer(this, converter);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        DurationDeserializer deser = this;
        boolean leniency = this._isLenient;
        DurationUnitConverter unitConverter = this._durationUnitConverter;
        Boolean timestampsAsNanosOverride = this._readTimestampsAsNanosOverride;
        if (format != null) {
            String pattern;
            if (format.hasLenient()) {
                leniency = format.getLenient();
            }
            if (format.hasPattern() && (unitConverter = DurationUnitConverter.from(pattern = format.getPattern())) == null) {
                ctxt.reportBadDefinition(this.getValueType(ctxt), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", pattern, DurationUnitConverter.descForAllowed()));
            }
            timestampsAsNanosOverride = format.getFeature(JsonFormat.Feature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
        }
        if (leniency != this._isLenient || !Objects.equals(unitConverter, this._durationUnitConverter) || !Objects.equals(timestampsAsNanosOverride, this._readTimestampsAsNanosOverride)) {
            return new DurationDeserializer(this, leniency, unitConverter, timestampsAsNanosOverride);
        }
        return deser;
    }

    @Override
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.currentTokenId()) {
            case 8: {
                BigDecimal value = parser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(value, Duration::ofSeconds);
            }
            case 7: {
                return this._fromTimestamp(context, parser.getLongValue());
            }
            case 6: {
                return this._fromString(parser, context, parser.getText());
            }
            case 1: {
                return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
            }
            case 12: {
                return (Duration)parser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(parser, context);
            }
        }
        return (Duration)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected Duration _fromString(JsonParser parser, DeserializationContext ctxt, String value0) throws IOException {
        String value = value0.trim();
        if (value.length() == 0) {
            return (Duration)this._fromEmptyString(parser, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        try {
            return Duration.parse(value);
        }
        catch (DateTimeException e) {
            return (Duration)this._handleDateTimeException(ctxt, e, value);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext ctxt, long ts) {
        if (this._durationUnitConverter != null) {
            return this._durationUnitConverter.convert(ts);
        }
        if (this.shouldReadTimestampsAsNanoseconds(ctxt)) {
            return Duration.ofSeconds(ts);
        }
        return Duration.ofMillis(ts);
    }

    protected boolean shouldReadTimestampsAsNanoseconds(DeserializationContext context) {
        return this._readTimestampsAsNanosOverride != null ? this._readTimestampsAsNanosOverride.booleanValue() : context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }
}

