/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.paper;

import com.google.gson.Gson;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;

public class NecrifyPaperPluginLoader
implements PluginLoader {
    public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) {
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        PluginLibraries pluginLibraries = this.load();
        pluginLibraries.asDependencies().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addDependency(arg_0));
        pluginLibraries.asRepositories().forEach(arg_0 -> ((MavenLibraryResolver)resolver).addRepository(arg_0));
        classpathBuilder.addLibrary((ClassPathLibrary)resolver);
    }

    private PluginLibraries load() {
        PluginLibraries pluginLibraries;
        block9: {
            InputStream in = this.getClass().getResourceAsStream("/paper-libraries.json");
            try {
                if (in == null) {
                    throw new IllegalStateException("Could not find paper-libraries.json");
                }
                pluginLibraries = (PluginLibraries)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), PluginLibraries.class);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return pluginLibraries;
    }

    private record PluginLibraries(Map<String, String> repositories, List<String> dependencies) {
        public Stream<Dependency> asDependencies() {
            return this.dependencies.stream().map(d -> new Dependency((Artifact)new DefaultArtifact(d), null));
        }

        public Stream<RemoteRepository> asRepositories() {
            return this.repositories.entrySet().stream().map(e -> new RemoteRepository.Builder((String)e.getKey(), "default", (String)e.getValue()).build());
        }
    }
}

