/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.paper.listeners;

import de.jvstvshd.necrify.paper.NecrifyPaperJavaPlugin;
import de.jvstvshd.necrify.paper.listeners.MuteInformation;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.time.LocalDateTime;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ChatListener
implements Listener {
    private final NecrifyPaperJavaPlugin plugin;

    public ChatListener(NecrifyPaperJavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        List mutes = this.plugin.cachedMutes().stream().filter(muteData -> event.getPlayer().getUniqueId().equals(muteData.getPlayer().getUniqueId())).collect(Collectors.toList());
        if (mutes.isEmpty()) {
            return;
        }
        mutes.sort(Comparator.comparing(MuteInformation::getDuration));
        ArrayDeque queue = new ArrayDeque(mutes);
        while (!queue.isEmpty()) {
            MuteInformation mute = (MuteInformation)queue.poll();
            if (!mute.getDuration().isPermanent() && mute.getDuration().expiration().isBefore(LocalDateTime.now())) {
                this.plugin.cachedMutes().remove(mute);
                continue;
            }
            event.setCancelled(true);
            event.getPlayer().sendMessage(mute.getReason());
            break;
        }
    }
}

