/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.paper.listeners;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import de.jvstvshd.necrify.common.plugin.MuteData;
import de.jvstvshd.necrify.common.util.Updater;
import de.jvstvshd.necrify.lib.jackson.core.JsonProcessingException;
import de.jvstvshd.necrify.paper.NecrifyPaperJavaPlugin;
import de.jvstvshd.necrify.paper.listeners.MuteInformation;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class MessagingChannelListener
implements PluginMessageListener {
    private final NecrifyPaperJavaPlugin plugin;

    public MessagingChannelListener(NecrifyPaperJavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        MuteData data;
        if (message.length == 0) {
            return;
        }
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
        String content = input.readUTF();
        try {
            data = MuteData.OBJECT_MAPPER.readValue(content, MuteData.class);
        }
        catch (JsonProcessingException e) {
            this.plugin.getSLF4JLogger().error("Could not parse MuteData", (Throwable)e);
            return;
        }
        if (data.getVersion() > 1) {
            this.plugin.getSLF4JLogger().warn("Received MuteData ({}) with higher version than supported ({}). This may lead to unexpected results as newer features might be expected by the incoming data.", (Object)data.getVersion(), (Object)1);
            Updater.updateInformation(this.plugin.getSLF4JLogger());
        } else if (data.getVersion() < 1) {
            this.plugin.getSLF4JLogger().warn("Received MuteData ({}) with lower version than supported ({}). Backwards compatibility should be ensured unless this version is really outdated.", (Object)data.getVersion(), (Object)1);
            Updater.updateInformation(this.plugin.getSLF4JLogger());
        }
        if (data.getType() == 3) {
            this.plugin.cachedMutes().removeIf(muteInformation -> muteInformation.getPlayer().getUniqueId().equals(data.getUuid()));
            return;
        }
        MuteInformation mute = MuteInformation.from(data);
        switch (data.getType()) {
            case 4: {
                this.plugin.cachedMutes().removeIf(muteInformation -> muteInformation.getPlayer().getUniqueId().equals(data.getUuid()));
                this.plugin.cachedMutes().add(mute);
                break;
            }
            case 0: {
                this.plugin.cachedMutes().add(mute);
                break;
            }
            case 1: {
                this.plugin.cachedMutes().removeIf(muteInformation -> muteInformation.getPunishmentUUID().equals(mute.getPunishmentUUID()));
                break;
            }
            case 2: {
                this.plugin.cachedMutes().stream().filter(muteInformation -> muteInformation.getPunishmentUUID().equals(mute.getPunishmentUUID())).findFirst().ifPresent(muteInformation -> muteInformation.updateTo(mute));
            }
        }
    }
}

