/*
 * Decompiled with CFR 0.152.
 */
package de.jvstvshd.necrify.paper.listeners;

import de.jvstvshd.necrify.api.duration.PunishmentDuration;
import de.jvstvshd.necrify.common.plugin.MuteData;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MuteInformation {
    private final Player player;
    private final UUID punishmentUUID;
    private Component reason;
    private PunishmentDuration duration;

    public MuteInformation(Component reason, PunishmentDuration duration, Player player, UUID punishmentUUID) {
        this.reason = reason;
        this.duration = duration;
        this.player = player;
        this.punishmentUUID = punishmentUUID;
    }

    public static MuteInformation from(MuteData muteData) {
        return new MuteInformation(MiniMessage.miniMessage().deserialize((Object)muteData.getReason()), PunishmentDuration.from(muteData.getExpiration()), Bukkit.getPlayer((UUID)muteData.getUuid()), muteData.getPunishmentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTo(MuteInformation other) {
        MuteInformation muteInformation = this;
        synchronized (muteInformation) {
            this.reason = other.reason;
            this.duration = other.duration;
        }
    }

    public Component getReason() {
        return this.reason;
    }

    public MuteInformation setReason(Component reason) {
        this.reason = reason;
        return this;
    }

    public PunishmentDuration getDuration() {
        return this.duration;
    }

    public MuteInformation setDuration(PunishmentDuration duration) {
        this.duration = duration;
        return this;
    }

    public Player getPlayer() {
        return this.player;
    }

    public UUID getPunishmentUUID() {
        return this.punishmentUUID;
    }
}

