package io.github.yunivers.keyf3.mixin.binds;

import io.github.yunivers.keyf3.KeyF3;
import net.minecraft.class_127;
import net.minecraft.class_25;
import net.minecraft.class_57;
import net.minecraft.class_579;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_579.class)
public class EntityRendererMixin
{
    @Inject(
        method = "postRender",
        at = @At("HEAD")
    )
    public void keyf3$postRender_renderHitboxes(class_57 entity, double dx, double dy, double dz, float yaw, float tickDelta, CallbackInfo ci)
    {
        if (!KeyF3.renderHitboxes)
            return;

        class_25 hitbox = entity.field_1610.method_98(-entity.field_1600, -entity.field_1601, -entity.field_1602);
        if (hitbox != null)
        {
            GL11.glPushMatrix();
            GL11.glLineWidth(3.0F);
            GL11.glTranslated(dx, dy, dz);
            GL11.glDisable(GL11.GL_TEXTURE_2D);
            GL11.glDisable(GL11.GL_LIGHTING);

            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            Minecraft.field_2791.field_2805.method_1545(hitbox);

            GL11.glColor4f(1.0F, 0.0F, 0.0F, 1.0F);
            hitbox.field_130 = hitbox.field_133 = entity.method_1378();
            if (entity instanceof class_127)
                Minecraft.field_2791.field_2805.method_1545(hitbox.method_93(0, 0.01, 0));

            GL11.glColor4f(0.0F, 0.0F, 1.0F, 1.0F);
            renderLine(
                new Vector3f(
                    (float)(hitbox.field_129 + (hitbox.field_132 - hitbox.field_129) / 2f),
                    (float)(hitbox.field_130 + (hitbox.field_133 - hitbox.field_130) / 2f),
                    (float)(hitbox.field_131 + (hitbox.field_134 - hitbox.field_131) / 2f)),
                2.0f,
                new Vector2f(
                    entity.field_1606,
                    entity.field_1607
                ));

            GL11.glEnable(GL11.GL_TEXTURE_2D);
            GL11.glEnable(GL11.GL_LIGHTING);
            GL11.glPopMatrix();
        }
    }

    @SuppressWarnings("SameParameterValue")
    @Unique
    private void renderLine(Vector3f origin, double dist, Vector2f dir)
    {
        double yawRad = Math.toRadians(dir.x);
        double pitchRad = Math.toRadians(dir.y);

        double dx = -Math.sin(yawRad) * Math.cos(pitchRad) * dist;
        double dy = -Math.sin(pitchRad) * dist;
        double dz = Math.cos(yawRad) * Math.cos(pitchRad) * dist;

        class_67 tessellator = class_67.field_2054;
        tessellator.method_1691(GL11.GL_LINES);
        tessellator.method_1687(origin.x, origin.y, origin.z);
        tessellator.method_1687(origin.x + (float)dx, origin.y + (float)dy, origin.z + (float)dz);
        tessellator.method_1685();
    }
}
