package io.github.yunivers.keyf3.mixin.binds;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.yunivers.keyf3.KeyF3;
import net.minecraft.class_54;
import net.minecraft.class_555;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_555.class)
public class GameRendererMixin
{
    @Shadow private Minecraft client;

    @Inject(
        method = "renderFrame",
        at = @At(
            value = "INVOKE",
            target = "Lorg/lwjgl/opengl/GL11;glBlendFunc(II)V",
            remap = false
        )
    )
    public void keyf3$renderFrame_renderChunkBorders(float tickDelta, long time, CallbackInfo ci,
                                                     @Local(ordinal = 0) double dx,
                                                     @Local(ordinal = 1) double dy,
                                                     @Local(ordinal = 2) double dz)
    {
        if (!KeyF3.renderChunkBorders)
            return;

        GL11.glPushMatrix();
        GL11.glLineWidth(1.0F);
        GL11.glTranslated(-dx, -dy, -dz);
        GL11.glDisable(GL11.GL_TEXTURE_2D);
        GL11.glDisable(GL11.GL_LIGHTING);

        class_54 player = client.field_2806;

        // Vertical Border Lines
        for (int x = player.field_1619 - 1; x <= player.field_1619 + 2; x++)
            for (int z = player.field_1621 - 1; z <= player.field_1621 + 2; z++)
                if ((x == player.field_1619 || x == player.field_1619 + 1) && (z == player.field_1621 || z == player.field_1621 + 1))
                    renderLine(new Vector3f(x * 16, 0, z * 16), new Vector3f(x * 16, 127, z * 16),0x3F3FFF);
                else
                    renderLine(new Vector3f(x * 16, 0, z * 16), new Vector3f(x * 16, 127, z * 16),0xFF0000);

        // Current Chunk Horizontal Lines
        for (int y = 0; y <= 128; y += 2)
        {
            int x = player.field_1619 * 16;
            int z = player.field_1621 * 16;
            int color = y % 16 == 0 ? 0x3F3FFF : y % 8 == 0 ? 0x009B9B : 0xFFFF00;

            if (y == 128)
                y--;

            renderLine(new Vector3f(x, y, z), new Vector3f(x, y, z + 16), color);
            renderLine(new Vector3f(x, y, z + 16), new Vector3f(x + 16, y, z + 16), color);
            renderLine(new Vector3f(x + 16, y, z + 16), new Vector3f(x + 16, y, z), color);
            renderLine(new Vector3f(x + 16, y, z), new Vector3f(x, y, z), color);
        }

        // Current Chunk Vertical Lines
        for (int x = 0; x <= 16; x += 2)
            for (int z = 0; z <= 16; z += 2)
                if ((x == 0 || x == 16 || z == 0 || z == 16) && !(x % 16 == 0 && z % 16 == 0))
                {
                    int fullX = player.field_1619 * 16 + x;
                    int fullZ = player.field_1621 * 16 + z;
                    int color = (x > 0 && x < 16 && x % 8 == 0) || (z > 0 && z < 16 && z % 8 == 0) ? 0x009B9B : 0xFFFF00;
                    renderLine(new Vector3f(fullX, 0, fullZ), new Vector3f(fullX, 127, fullZ), color);
                }

        GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }

    @Unique
    private void renderLine(Vector3f startPos, Vector3f endPos, int color)
    {
        float r = ((color >> 16) & 0xFF) / 255.0f;
        float g = ((color >> 8) & 0xFF) / 255.0f;
        float b = (color & 0xFF) / 255.0f;
        GL11.glColor3f(r, g, b);

        class_67 t = class_67.field_2054;
        t.method_1691(GL11.GL_LINES);
        t.method_1687(startPos.x, startPos.y, startPos.z);
        t.method_1687(endPos.x, endPos.y, endPos.z);
        t.method_1685();
    }

    @WrapOperation(
        method = "onFrameUpdate",
        at = @At(
            value = "INVOKE",
            target = "Lorg/lwjgl/opengl/Display;isActive()Z",
            remap = false
        )
    )
    public boolean keyf3$onFrameUpdate_dontPauseOnInactive(Operation<Boolean> original)
    {
        if (!KeyF3.dontPauseOnInactive)
            return original.call();

        client.field_2778 = original.call();
        return true;
    }
}
