/*
 * Decompiled with CFR 0.152.
 */
package io.github.yunivers.keyf3.registry;

import com.mojang.serialization.Lifecycle;
import io.github.yunivers.keyf3.KeyF3;
import io.github.yunivers.keyf3.registry.event.F3BindRegistryEvent;
import io.github.yunivers.keyf3.registry.helper.F3Bind;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.registry.MutableRegistry;
import net.modificationstation.stationapi.api.registry.Registries;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.registry.RegistryKey;
import net.modificationstation.stationapi.api.registry.SimpleRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public class F3BindRegistry
extends SimpleRegistry<F3Bind> {
    public static final RegistryKey<Registry<F3Bind>> KEY = RegistryKey.ofRegistry((Identifier)KeyF3.NAMESPACE.id("f3binds"));
    public static final F3BindRegistry INSTANCE = (F3BindRegistry)Registries.create(KEY, (MutableRegistry)new F3BindRegistry(), (Lifecycle)Lifecycle.experimental());

    public F3BindRegistry() {
        super(KEY, Lifecycle.experimental(), false);
    }

    public static F3Bind bind(String name) {
        Optional bind = INSTANCE.getOrEmpty(Identifier.of((String)name));
        return bind.orElse(null);
    }

    public static F3Bind[] getBinds() {
        ArrayList<F3Bind> blocks = new ArrayList<F3Bind>();
        Iterator iterator = INSTANCE.iterator();
        while (iterator.hasNext()) {
            F3Bind bind = (F3Bind)iterator.next();
            blocks.add(bind);
        }
        return blocks.toArray(new F3Bind[0]);
    }

    public static boolean hasBind(int key) {
        Iterator iterator = INSTANCE.iterator();
        while (iterator.hasNext()) {
            F3Bind bind = (F3Bind)iterator.next();
            if (bind.key != key) continue;
            return true;
        }
        return false;
    }

    public static Identifier getBindIdentifier(F3Bind bind) {
        return INSTANCE.getId(bind);
    }

    @EventListener
    public static void registerF3Binds(F3BindRegistryEvent event) {
        event.register(KeyF3.NAMESPACE).accept((Object)"f3bind_reloadChunks", (Object)new F3Bind("Reload chunks", 30, "Reloading all chunks")).accept((Object)"f3bind_showHitboxes", (Object)new F3Bind("Show hitboxes", 48)).accept((Object)"f3bind_copyTp", (Object)new F3Bind("Copy location as /tp command, hold F3 + C to crash the game", 46, "Copied location to clipboard")).accept((Object)"f3bind_clearChat", (Object)new F3Bind("Clear chat", 32)).accept((Object)"f3bind_showChunkBorders", (Object)new F3Bind("Show chunk boundaries", 34)).accept((Object)"f3bind_pauseInactive", (Object)new F3Bind("Pause on lost focus", 25)).accept((Object)"f3bind_showBinds", (Object)new F3Bind("Show this list", 16, "Key bindings:")).accept((Object)"f3bind_reloadPack", (Object)new F3Bind("Reload resource packs", 20, "Reloaded resource packs")).accept((Object)"f3bind_hiddenPause", (Object)new F3Bind("Pause without pause menu (if pausing is possible)", 1));
        if (FabricLoader.getInstance().isModLoaded("bhcreative")) {
            event.register(KeyF3.NAMESPACE).accept((Object)"f3bind_toggleCreative", (Object)new F3Bind("Cycle survival <-> creative", 62));
        }
    }
}

