package com.bawnorton.trimica.api;

import com.bawnorton.trimica.item.crafting.DefaultCraftingRecipeInterceptor;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import com.bawnorton.trimica.data.tags.UnloadedTagHolder;
import org.jetbrains.annotations.Nullable;

/**
 * @see DefaultCraftingRecipeInterceptor for default behaviour
 */
@SuppressWarnings("unused")
public interface CraftingRecipeInterceptor {
	default class_6885<class_1792> getTag(class_6862<class_1792> tagKey) {
		return UnloadedTagHolder.getUnloadedTag(tagKey);
	}

	/**
	 * The {@link class_1856} to use for the addition ingredient in a smithing trim recipe.
	 *
	 * @return current ingredient if no changes are made, or a new ingredient to use instead.
	 * @apiNote to get the content of a tag, use {@link #getTag(class_6862)}. Tags cannot be queried directly as they are not loaded yet.
	 */
	class_1856 getAdditionIngredient(@Nullable class_1856 current);

	/**
	 * The {@link class_1856} to use for the base ingredient in a smithing trim recipe.
	 *
	 * @return current ingredient if no changes are made, or a new ingredient to use instead.
	 * @apiNote to get the content of a tag, use {@link #getTag(class_6862)}. Tags cannot be queried directly as they are not loaded yet.
	 */
	class_1856 getBaseIngredient(@Nullable class_1856 current);
}
